using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;

namespace SlothLib.Web.WebLoader
{
    /// <summary>
    /// MultiWebGetǗNX
    /// </summary>
    public class WebGetManager
    {
        private string[] urlList;
        private int maxThreadCount;
        private string[] outFiles;
        private string[] tagertContentType;
        private string[] excludeContentType;
        private string proxy;
        private string userAgent;

        /// <summary>
        /// ICxg
        /// </summary>
        public ManualResetEvent finishEvent;

        /// <summary>
        /// ʂ̊i[p
        /// </summary>
        private WebGetResult[] resultElements;

        /// <summary>
        /// GetNextUrlIndexł̂ݗpB
        /// </summary>
        private int cur;

        /// <summary>
        /// IACě
        /// </summary>
        private int finishNum;

        /// <summary>
        /// ʂ擾郁\bh
        /// </summary>
        /// <returns></returns>
        public WebGetResult[] GetResult()
        {
            // SłĂԂ܂BrȂnullԂB
            if (this.finishNum == this.urlList.Length)
            {
                return resultElements;
            }
            else
            {
                return null;
            }
        }


        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="urls">擾ΏۂURL</param>
        /// <param name="maxThreadCount">őXbh</param>
        /// <param name="outFiles">t@C̕ۑ</param>
        /// <param name="targetContentType">擾ΏۂContentType</param>
        /// <param name="excludeContentType">OContentType</param>
        /// <param name="finishEvent">finishEvent</param>
        /// <param name="proxy">HTTPʐMɗpproxy</param>
        /// <param name="userAgent">HTTPʐMɗpUserAgent</param>
        public WebGetManager(string[] urls, int maxThreadCount, string[] outFiles, string[] targetContentType, string[] excludeContentType, ManualResetEvent finishEvent, string proxy, string userAgent)
        {
            //List<string> urlList = new List<string>(urls);

            this.urlList = urls;
            this.maxThreadCount = maxThreadCount;
            this.outFiles = outFiles;
            this.tagertContentType = targetContentType;
            this.excludeContentType = excludeContentType;

            this.finishEvent = finishEvent;
            this.proxy = proxy;
            this.userAgent = userAgent;

            this.resultElements = new WebGetResult[urlList.Length];

            // Oɏ_url̃CfbNX
            this.cur = -1;
        }

        /// <summary>
        /// WebGetɓႤ
        /// </summary>
        public void WorkerThread(object wtState)
        {
            // 񈵂URL̃CfbNX
            int iUrl = 0;

            while (true)
            {
                try
                {
                    // 񈵂URL̃CfbNX擾
                    iUrl = this.GetNextUrlIndex();
                    // ׂdȂXbhI
                    if (iUrl < 0)
                    {
                        break;
                    }
                    // URLEOutFile擾
                    string workUrl = this.urlList[iUrl];
                    string workOutFile = this.outFiles[iUrl];

                    WebGet wg = new WebGet();
                    wg.Proxy = this.proxy;
                    wg.UserAgent = userAgent;
                    WebGetResult res = wg.DoFetch(workUrl, workOutFile, this.tagertContentType, this.excludeContentType);

                    // ʂǉB
                    lock (this.resultElements)
                    {
                        //this._resultElements.Add(re);
                        //ȂĂ܂ƁAbN͕KvȂƎvǂˁB
                        this.resultElements[iUrl] = res;
                    }
                }
                catch
                {
                    throw;
                }
                finally
                {
                    // Ɠꍇ̂ݏB
                    if (iUrl >= 0)
                    {
                        lock (this)
                        {
                            // IB

                            this.finishNum++;
                        }
                    }

                    // ŌURLq͌nB
                    //if ( iUrl == this._urls.Length - 1)
                    if (this.finishNum == this.urlList.Length)
                    {
                        this.finishEvent.Set();
                        // ۂɃXbhÎ́Ả-1ĂĂB
                    }
                }
            }
        }


        /// <summary>
        /// ̎dnB
        /// </summary>
        private int GetNextUrlIndex()
        {
            // bNII
            lock (this)
            {
                // ͂܂B
                if (this.cur >= this.urlList.Length - 1)
                {
                    return -1;
                }
                else
                {
                    this.cur++;
                    return this.cur;
                }
            }
        }
    }
}
