using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// Yahoo! Webʂ̗vfi[
    /// </summary>
	[Serializable]
	public class YahooJpWebElement : IWebElement
	{
		
		#region privatetB[h

		int rank;

		string title;
		string summary;
		string url;
		string clickUrl;
		string mimeType;
		string modificationDate;
		string cacheUrl;
		string cacheSize;

		#endregion


        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="rank">GWɂꂽLO</param>
        /// <param name="title">y[W̃^Cg</param>
        /// <param name="summary">y[WɊ֘AeLXgT}[</param>
		/// <param name="url">y[WURL</param>
		/// <param name="clickUrl">y[W̃NURL</param>
		/// <param name="mimeType">y[WMIME^Cv</param>
		/// <param name="modificationDate">y[WŌɏCꂽt</param>
		/// <param name="cacheUrl">LVʂURL</param>
        /// <param name="cacheSize">LVʃTCY</param>
		public YahooJpWebElement(int rank, string title, string summary, string url, string clickUrl,
			string mimeType, string modificationDate, string cacheUrl, string cacheSize)
        {
			this.rank = rank;
			this.title = HttpUtility.HtmlDecode(title);
            this.summary = HttpUtility.HtmlDecode(summary);
			this.url = url;
			this.clickUrl = clickUrl;
			this.mimeType = mimeType;
			this.modificationDate = modificationDate;
			this.cacheUrl = cacheUrl;
			this.cacheSize = cacheSize;
        }

        #endregion


        #region vpeB

        /// <summary>
        /// y[W̃^Cg
        /// </summary>
        public string Title
        {
            get
            {
                return this.title;
            }
        }

        /// <summary>
        /// y[W̗v
        /// </summary>
        public string Summary
        {
            get
            {
                return this.summary;
            }
        }

		/// <summary>
		/// y[WURL
		/// </summary>
		public string Url
		{
			get
			{
				return this.url;
			}
		}

        /// <summary>
        /// y[W̃NURL
        /// </summary>
        public string ClickUrl
        {
            get
            {
                return this.clickUrl;
            }
        }

		/// <summary>
		/// y[WMime^Cv
		/// </summary>
		public string MimeType
		{
			get
			{
				return this.mimeType;
			}
		}

        /// <summary>
        /// y[WŌɏCꂽt
        /// </summary>
		public DateTime ModificationDate
		{
			get
			{
				if (string.IsNullOrEmpty(this.modificationDate))
				{
					return new DateTime();
				}
				else
				{
					//UNIX^CX^vDateTime^ɕϊ
					DateTime baseTime = new DateTime(1970, 1, 1);
					try
					{
						return baseTime.AddSeconds(double.Parse(this.modificationDate));
					}
					catch
					{
					}
				}
				return new DateTime();
			}
		}

        /// <summary>
        /// LbVy[WURL
        /// </summary>
        public string CacheUrl
        {
            get
            {
                return this.cacheUrl;
            }
        }

        /// <summary>
        /// LbVy[W̃TCY
        /// </summary>
        public int CacheSize
        {
            get
            {
                if (!string.IsNullOrEmpty(this.cacheSize))
                {
                    try
                    {
                        return int.Parse(this.cacheSize);
                    }
                    catch
                    {
                    }
                    return 0;
                }
                else
                {
                    return 0;
                }
            }
        }

        /// <summary>
        /// ʂ̏
        /// </summary>
        public int Rank
        {
            get
            {
                return this.rank;
            }
        }

        #endregion


        #region ISearchResultElement o

        /// <summary>
		/// y[WURL
		/// </summary>
        string ISearchResultElement.URL
		{
			get { return this.Url; }
		}

		/// <summary>
		/// y[W̃^Cg
		/// </summary>
        string ISearchResultElement.Title
		{
			get { return this.Title; }
		}

		/// <summary>
		/// y[W̗v
		/// </summary>
        string ISearchResultElement.Description
		{
			get { return this.Summary; }
		}

        /// <summary>
        /// GWɂꂽLO
        /// </summary>
        int ISearchResultElement.Rank
        {
            get
            {
                return this.rank;
            }
        }

        #endregion

        /// <summary>
        /// ToString̃I[o[Ch
        /// </summary>
        /// <returns>Flickrʗvf̓e</returns>
		public override string ToString()
		{
			return "Title: " + title + "\r\n"
				+ "URL: " + url + "\r\n"
				+ "Summary: " + summary;
		}





		#region ISerializable o

        /// <summary>
        /// VACYƂɌĂяo֐
        /// </summary>
        /// <param name="info">tVAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue("rank", this.rank);
			info.AddValue("title", this.title);
			info.AddValue("summary", this.summary);
			info.AddValue("url", this.url);
			info.AddValue("clickUrl", this.clickUrl);
			info.AddValue("mimeType", this.mimeType);
			info.AddValue("modificationDate", this.modificationDate);
			info.AddValue("cacheUrl", this.clickUrl);
			info.AddValue("cacheSize", this.cacheSize);
		}

        /// <summary>
        /// VACYꂽ̂fVACYꂽƂɌĂ΂RXgN^
        /// </summary>
        /// <param name="info">VAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
		protected YahooJpWebElement(SerializationInfo info, StreamingContext context)
		{
			this.rank = info.GetInt32("rank");
			this.title = info.GetString("title");
			this.summary = info.GetString("summary");
			this.url = info.GetString("url");
			this.clickUrl = info.GetString("clickUrl");
			this.mimeType = info.GetString("mimeType");
			this.modificationDate = info.GetString("modificationDate");
			this.cacheUrl = info.GetString("cacheUrl");
			this.cacheSize = info.GetString("cacheSize");
			//this.ht = (Hashtable) info.GetValue("ht", typeof(Hashtable));
		}


		#endregion
	}
}
