﻿// [ohshima][2007-03-04] 修正
// [tyamamot][2007-05-07] 修正

using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// Yahoo! 動画検索の検索結果要素を格納するクラス
    /// </summary>
	[Serializable]
	public class YahooJpVideoElement : IVideoElement
    {

        #region コンストラクタ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="rank">検索順位</param>
        /// <param name="title">動画ファイルのタイトル</param>
        /// <param name="summary">動画ファイルに関連するテキストサマリー</param>
        /// <param name="url">動画ファイルやストリームのURL</param>
        /// <param name="clickUrl">動画ファイルのリンクURL</param>
        /// <param name="refererUrl">動画コンテンツを含むページのURL</param>
        /// <param name="fileSize">ファイルサイズ 単位はバイト</param>
        /// <param name="fileFormat">avi、flash、mpeg、msmedia、quicktime、またはrealmediaのいずれか</param>
        /// <param name="height">動画から取得したキーフレームの高さ 単位はピクセル</param>
        /// <param name="width">動画から取得したキーフレームの幅 単位はピクセル</param>
        /// <param name="duration">動画ファイルの時間 単位は秒</param>
        /// <param name="channels">オーディオチャネル数 通常は1（モノラル）か2（ステレオ）</param>
        /// <param name="streaming">動画ファイルがストリーミングである（true）か、ストリーミングでない（false）か</param>
        /// <param name="thumbnailUrl">サムネイルのURL</param>
        /// <param name="thumbnailHeight">サムネイルの高さ 単位はピクセル</param>
        /// <param name="thumbnailWidth">サムネイルの幅 単位はピクセル</param>
        /// <param name="publisher">動画ファイルの提供者</param>
        /// <param name="restrictions">このメディアオブジェクトの制限事項です。制限事項はnoframeまたはnoinlineです。
        ///                             noframeとは、サイト内のフレームで表示してはいけないことを意味します。
        ///                             noinlineとは、フレーム上のインラインオブジェクトとして表示してはいけないことを意味します
        ///                             （サイトに"referrer"などの保護がされているため、動作しません）</param>
        /// <param name="copyright">オーナーのコピーライト</param>
        public YahooJpVideoElement(int rank,string title, string summary, string url, string clickUrl, string refererUrl,
            string fileSize, string fileFormat, string height, string width, string duration, string channels, string streaming,
            string thumbnailUrl, string thumbnailHeight, string thumbnailWidth, string publisher,
            string restrictions, string copyright)
        {
            this.rank = rank;
            this.title = HttpUtility.HtmlDecode(title); this.summary = HttpUtility.HtmlDecode(summary); this.url = url; this.clickUrl = clickUrl; this.refererUrl = refererUrl;
			this.fileSize = fileSize; this.fileFormat = fileFormat; this.height = height; this.width = width; this.duration = duration;
			this.channels = channels; this.streaming = streaming; this.thumbnailUrl = thumbnailUrl;
			this.thumbnailHeight = thumbnailHeight; this.thumbnailWidth = thumbnailWidth; this.publisher = publisher; this.restrictions = restrictions;
            this.copyright = copyright;
        }

        #endregion


        #region privateフィールド
        int rank;
        string title;
        string summary;
        string url;
        string clickUrl;
        string refererUrl;
        string fileSize;
        string fileFormat;
        string height;
        string width;
        string duration;
        string channels;
        string streaming;
        string thumbnailUrl;
        string thumbnailHeight;
        string thumbnailWidth;
        string publisher;
        string restrictions;
        string copyright;

        #endregion

    
        #region プロパティ

        /// <summary>
        /// 動画のタイトル
        /// </summary>
        public string Title
        {
            get
            {
                return this.title;
            }
        }

        /// <summary>
        /// 動画ファイルに関連するテキストサマリー
        /// </summary>
        public string Summary
        {
            get
            {
                return this.summary;
            }
        }

        /// <summary>
        /// 動画ファイルやストリームのURL
        /// </summary>
        public string Url
        {
            get
            {
                return this.url;
            }
        }

        /// <summary>
        /// 動画ファイルやリンクURL
        /// </summary>
        public string ClickUrl
        {
            get
            {
                return this.clickUrl;
            }
        }

        /// <summary>
        /// 動画コンテンツを含むページのURL
        /// </summary>
        public string RefererUrl
        {
            get
            {
                return this.refererUrl;
            }
        }

        /// <summary>
        /// ファイルサイズ　単位はバイト
        /// </summary>
        public string FileSize
        {
            get
            {
                return this.fileSize;
            }

        }

        /// <summary>
        /// avi、flash、mpeg、msmedia、quicktime、またはrealmediaのいずれか
        /// </summary>
        public string FileFormat
        {
            get
            {
                return this.fileFormat;
            }
        }

        /// <summary>
        /// 動画から取得したキーフレームの高さ 単位はピクセル
        /// </summary>
        public int Height
        {
            get
            {
                try
                {

                    return int.Parse(this.height);
                }
                catch
                {
                }
                return 0;
            }
        }

        /// <summary>
        /// 動画から取得したキーフレームの幅 単位はピクセル
        /// </summary>
        public int Width
        {
            get
            {
                try
                {

                    return int.Parse(this.width);
                }
                catch
                {
                }
                return 0;
            }
        }

        /// <summary>
        /// 動画ファイルの時間 単位は秒
        /// </summary>
        public int Duration
        {
            get
            {
                try
                {

                    return int.Parse(this.duration);
                }
                catch
                {
                }
                return 0;
            }
        }

        /// <summary>
        /// オーディオチャネル数 通常は1（モノラル）か2（ステレオ）
        /// </summary>
        public int Channels{
            get
            {
                try
                {

                    return int.Parse(this.channels);
                }
                catch
                {
                }
                return 0;
            }
        }

        /// <summary>
        /// 動画ファイルがストリーミングである（true）か、ストリーミングでない（false）か
        /// </summary>
        public bool Streaming
        {
            get
            {
                try
                {
                    return bool.Parse(this.streaming);
                }
                catch
                {
                }
                return false;
            }
        }

        /// <summary>
        /// サムネイルのURL
        /// </summary>
        public string Thumbnail_Url
        {
            get
            {
                    return this.thumbnailUrl;
            }
        }

        /// <summary>
        /// サムネイルの高さ 単位はピクセル
        /// </summary>
        public int Thumbnail_Height
        {
            get
            {
                try
                {
                    return int.Parse(this.thumbnailHeight);
                }
                catch
                {
                }
                return 0;
            }
        }

        /// <summary>
        /// サムネイルの幅 単位はピクセル
        /// </summary>
        public int Thumbnail_Width
        {
            get
            {
                try
                {
                    return int.Parse(this.thumbnailWidth);
                }
                catch
                {
                }
                return 0;
            }
        }

        /// <summary>
		/// 動画ファイルの提供者です。
        /// </summary>
        public string Publisher
        {
            get
            {
                    return this.publisher;
            }
        }

        /// <summary>
		/// オーナーのコピーライトです。
        /// </summary>
        public string Copyright
        {
            get
            {
                return this.copyright;
            }
        }

        /// <summary>
        /// このメディアオブジェクトの制限事項
        /// noframeとは、サイト内のフレームで表示してはいけないことを意味します。
        /// noinlineとは、フレーム上のインラインオブジェクトとして表示してはいけないことを意味します
        /// サイトに"referrer"などの保護がされているため、動作しません)
        /// </summary>
        public string Restrictions
        {
            get
            {
                return this.restrictions;
            }
        }

        #endregion





        #region ISearchResultElement メンバ

        string ISearchResultElement.URL
        {
            get 
            {
                return this.url;

            }
        }

        string ISearchResultElement.Title
        {
            get
            {
                return this.title;
            }
        }

        string ISearchResultElement.Description
        {
            get
            {
                return this.summary;
            }
        }


        /// <summary>
        /// 検索エンジンにつけられたランキング
        /// </summary>
        int ISearchResultElement.Rank
        {
            get
            {
                return this.rank;
            }
        }

        #endregion

        #region IVideoElement メンバ

        int IVideoElement.Duration
        {
            get
            {
                try
                {
                    return int.Parse(this.duration);
                }
                catch
                {
                    return 0;
                }
            }
        }

        string IVideoElement.ThumbnailURL
        {
            get
            {
                return this.thumbnailUrl;
            }
        }

        #endregion

        #region ISerializable メンバ

        /// <summary>
        /// シリアライズ化するときに呼び出される関数
        /// </summary>
        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
        {
			info.AddValue("rank", this.rank);
			info.AddValue("title", this.title);
			info.AddValue("summary", this.summary);
			info.AddValue("url", this.url);
			info.AddValue("clickUrl", this.clickUrl);
            info.AddValue("refererUrl",this.refererUrl);
            info.AddValue("restrictions",this.restrictions);
            info.AddValue("channels",this.channels);
            info.AddValue("copyright",this.copyright);
            info.AddValue("duration", this.duration);
            info.AddValue("fileFormat", this.fileFormat);
            info.AddValue("fileSize", this.fileSize);
            info.AddValue("height", this.height);
            info.AddValue("width", this.width);
            info.AddValue("publisher", this.publisher);
            info.AddValue("streaming", this.streaming);
            info.AddValue("thumbnailHeight", this.thumbnailHeight);
            info.AddValue("thumbnailWidth", this.thumbnailWidth);
            info.AddValue("thumbnailUrl", this.thumbnailUrl);
		
        }

        /// <summary>
        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
        /// </summary>
        /// <param name="info">シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
        protected YahooJpVideoElement(SerializationInfo info, StreamingContext context)
        {
            this.channels = info.GetString("channels");
            this.clickUrl = info.GetString("clickUrl");
            this.copyright = info.GetString("copyright");
            this.duration = info.GetString("duration");
            this.fileFormat = info.GetString("fileFormat");
            this.fileSize = info.GetString("fileSize");
            this.height = info.GetString("height");
            this.publisher = info.GetString("publisher");
            this.rank = info.GetInt32("rank");
            this.refererUrl = info.GetString("refererUrl");
            this.restrictions = info.GetString("restrictions");
            this.streaming = info.GetString("streaming");
            this.summary = info.GetString("summary");
            this.thumbnailHeight = info.GetString("thumbnailHeight");
            this.thumbnailUrl = info.GetString("thumnailUrl");
            this.thumbnailWidth = info.GetString("thumnailWidth");
            this.title = info.GetString("title");
            this.url = info.GetString("url");
            this.width = info.GetString("width");
        }

        #endregion


    }
}
