using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// Yahoo Web 摜ԂʑŚB
    /// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-05-24][kondo]쐬</newpara>
    /// <newpara>[2007-06-23][kondo]C</newpara>
    /// </remarks>
    [Serializable]
    public class YahooJpImageSearchResult : IImageSearchResult
    {

        #region private tB[h

        private YahooJpImageElement[] resultElements;
        private string query;

        private long totalResultsAvailable;
        private int totalResultsReturned;
        private int firstResultPosition;
        //private List<ISearchResultElement> elementList;

        #endregion

        #region RXgN^

		/// <summary>
		/// RXgN^
		/// </summary>
        /// <param name="query">NG</param>
		/// <param name="totalResultsAvailable">f[^̃}b`NGłB</param>
		/// <param name="totalResultsReturned">ԋpA}b`NG̐łBLȌʂ̍vȂꍇAvʂ̐菭Ȃꍇ܂B</param>
		/// <param name="firstResultPosition">Sʂ̍ŏ̃|WVłB</param>
		/// <param name="resultElements"></param>
		public YahooJpImageSearchResult(string query, long totalResultsAvailable, int totalResultsReturned, int firstResultPosition, YahooJpImageElement[] resultElements)
		{
			this.query = query;

			this.totalResultsAvailable = totalResultsAvailable;
			this.totalResultsReturned = totalResultsReturned;
			this.firstResultPosition = firstResultPosition;
            //this.elementList = new List<ISearchResultElement>(resultElements);
            this.resultElements = resultElements;
        }

        #endregion 

        #region vpeB

        /// <summary>
        /// ʗvf̔z
        /// </summary>
        public YahooJpImageElement[] ResultElements
        {
            get { return this.resultElements; }
        }

        /// <summary>
        /// ɎgꂽNG
        /// </summary>
        public string Query
        {
            get
            {
                return this.query;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public long TotalResultsAvailable
        {
            get
            {
                return this.totalResultsAvailable;
            }
        }

        /// <summary>
        /// ̌ʂɊ܂܂錟ʐ
        /// </summary>
        public int TotalResultsReturned
        {
            get
            {
                return this.totalResultsReturned;
            }
        }

        /// <summary>
        /// Sʂ̍ŏ̃|WV
        /// </summary>
        public int FirstResultPosition
        {
            get
            {
                return this.firstResultPosition;
            }
        }

        ///// <summary>
        ///// ʂ̗vf̔z
        ///// </summary>
        //public YahooJpImageElement[] ResultElements
        //{
        //    get
        //    {
        //        YahooJpImageElement[] result = new YahooJpImageElement[this.elementList.Count];
        //        for (int i = 0; i < this.elementList.Count; i++)
        //        {
        //            result[i] = (YahooJpImageElement)this.elementList[i];
        //        }
        //        return result;
        //    }
        //}

        //public int Count
        //{
        //    get
        //    {
        //        return this.elementList.Count;
        //    }
        //}

        #endregion

        #region ISearchResult o

        /// <summary>
        /// ʗvf̔z
        /// </summary>
        ISearchResultElement[] ISearchResult.ResultElements
        {
            get { return this.ResultElements; }
        }

        /// <summary>
        /// ɎgꂽNG
        /// </summary>
        string ISearchResult.Query
        {
            get { return this.Query; }
        }

        /// <summary>
        /// 
        /// </summary>
        long ISearchResult.TotalNumber
        {
            get
            {
                return this.totalResultsAvailable;
            }
        }

        //ISearchResultElement ISearchResult.this[int index]
        //{
        //    get
        //    {
        //        return this.elementList[index];
        //    }
        //}

        //int ISearchResult.Count
        //{
        //    get
        //    {
        //        return this.Count;
        //    }
        //}

        #endregion

        #region IImageSearchResult o

        /// <summary>
        /// ʗvf̔z
        /// </summary>
        IImageElement[] IImageSearchResult.ResultElements
        {
            get { return this.ResultElements; }
        }

        //IImageElement IImageSearchResult.this[int index]
        //{
        //    get
        //    {
        //        return (IImageElement)this.elementList[index];
        //    }
        //}

        #endregion

        #region ISerializable o

        /// <summary>
        /// VACYƂɌĂяo֐
        /// </summary>
        /// <param name="info">tVAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
            info.AddValue("query", this.query);
			info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
			info.AddValue("totalResultsReturned", this.totalResultsReturned);
			info.AddValue("firstResultPosition", this.firstResultPosition);
            //info.AddValue("elementList", this.elementList);
            info.AddValue("resultElements", this.resultElements);
        }

        /// <summary>
        /// VACYꂽ̂fVACYꂽƂɌĂ΂RXgN^
        /// </summary>
        /// <param name="info">VAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
		protected YahooJpImageSearchResult(SerializationInfo info, StreamingContext context)
		{
            this.query = info.GetString("query");
			this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
			this.totalResultsReturned = info.GetInt32("totalResultsReturned");
			this.firstResultPosition = info.GetInt32("firstResultPosition");
            //this.elementList = (List<ISearchResultElement>)info.GetValue("elementList", typeof(List<ISearchResultElement>));
            this.resultElements = (YahooJpImageElement[])info.GetValue("resultElements", typeof(YahooJpImageElement[]));
        }

        #endregion

    }
}
