﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// 教えて！Goo検索が返す検索結果全体
    /// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-06-12][inagawa]作成</newpara>
    /// </remarks>
    public class OshieteGooSearchResult : ISearchResult
    {
        #region privateフィールド
        private OshieteGooElement[] resultElements;
        private string query;
        private long searchTotalResults;
        //private List<ISearchResultElement> elementList;
        #endregion

        #region プロパティ

        /// <summary>
        /// 検索結果要素の配列
        /// </summary>
        public OshieteGooElement[] ResultElements
        {
            get { return this.resultElements; }
        }

        /// <summary>
        /// クエリ
        /// </summary>
        public string Query
        {
            get { return this.query; }
        }

        /// <summary>
        /// 検索ヒット数
        /// </summary>
        public long SearchTotalResults
        {
            get { return this.searchTotalResults; }
        }

        // <summary>
        // 取得した結果要素の数
        // </summary>
        //public int Count
        //{
        //    get { return this.resultElements.Length; }
        //}

        #endregion

        #region コンストラクタ
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="query">クエリ</param>
        /// <param name="searchTotalResults">検索ヒット数</param>
        /// <param name="resultElements">結果要素の配列</param>
        public OshieteGooSearchResult(string query, long searchTotalResults, OshieteGooElement[] resultElements)
        {
            this.query = query;
            this.searchTotalResults = searchTotalResults;
            this.resultElements = resultElements;
        }

        #endregion

        #region その他のメソッド
        /// <summary>
        /// 概要のリストを返すメソッド
        /// </summary>
        /// <returns></returns>
        public List<string> GetDescriptionList()
        {
            List<string> sList = new List<string>();
            foreach (OshieteGooElement element in resultElements)
            {
                sList.Add(element.Description);
            }
            return sList;
        }
        #endregion


        #region ISearchResult メンバ

        ISearchResultElement[] ISearchResult.ResultElements
        {
            get { return this.ResultElements; }
        }

        string ISearchResult.Query
        {
            get { return this.Query; }
        }

        long ISearchResult.TotalNumber
        {
            get { return this.SearchTotalResults; }
        }

        //ISearchResultElement ISearchResult.this[int index]
        //{
        //    get { return this.resultElements[index]; }
        //}

        //int ISearchResult.Count
        //{
        //    get { return this.Count; }
        //}

        #endregion


        #region ISerializable メンバ

        void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
        {
            info.AddValue("query", this.query);
            info.AddValue("searchTotalResults", this.searchTotalResults);
            info.AddValue("resultElements", this.resultElements);
        }

        /// <summary>
        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
        /// </summary>
        /// <param name="info"></param>
        /// <param name="context"></param>
        protected OshieteGooSearchResult(SerializationInfo info, StreamingContext context)
        {
            this.query = info.GetString("query");
            this.searchTotalResults = info.GetInt64("searchTotalResults");
            this.resultElements = (OshieteGooElement[])info.GetValue("resultElements", typeof(OshieteGooElement[]));
        }

        #endregion
    }
}
