using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.IO;
using System.Web;
using System.Net;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// GooBlogsNX
    /// </summary>
    public class GooBlogSearch : IBlogSearch
    {

        #region privatetB[h

        private SortType sortType;
        private WebProxy proxy;
        
        #endregion

        #region RXgN^

        /// <summary>
        /// RXgN^
        /// </summary>
        public GooBlogSearch()
        {
            this.proxy = null;
            this.sortType = SortType.Score;
        }

        #endregion

        #region DoSearch
        
        /// <summary>
        /// GooBlogs
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">ʎ擾</param>
        /// <returns>GooBlogSearchResult^̌</returns>
        public GooBlogSearchResult DoSearch(string query, int resultNum)
        {
            return DoGooBlogSearchOver(query, resultNum);
        }

        #region IBlogSearch o

        /// <summary>
        /// GooBlogs
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">ʎ擾</param>
        /// <returns>GooBlogSearchResult^̌</returns>
        IBlogSearchResult IBlogSearch.DoSearch(string query, int resultNum)
        {
            return DoSearch(query, resultNum);
        }

        #endregion

        #region ISearch o

        /// <summary>
        /// GooBlogs
        /// </summary>
        /// <param name="query">NG</param>
        /// <param name="resultNum">ʎ擾</param>
        /// <returns>GooBlogSearchResult^̌</returns>
        ISearchResult ISearch.DoSearch(string query, int resultNum)
        {
            return DoSearch(query, resultNum);
        }

        #endregion

        #endregion

        #region private\bh

        private GooBlogSearchResult DoGooBlogSearch(string query, int start, int resultNum, int tureResultNum)
        {
            string requestURL = MakeRequestURL(query, start, resultNum);
            System.Diagnostics.Debug.WriteLine("start! "  + requestURL);
            XmlDocument xmlDoc = new XmlDocument();

            HttpStatusCode statusCode;

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(requestURL);
            if (this.proxy != null)
            {
                req.Proxy = proxy;
            }
            using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
            using (Stream st = res.GetResponseStream())
            {
                xmlDoc.Load(st);
                statusCode = res.StatusCode;
            }

            if (statusCode != HttpStatusCode.OK)
            {

            }

            List<GooBlogElement> resultElementList = new List<GooBlogElement>();

            // [g̗vf擾
            XmlElement xmlRoot = xmlDoc.DocumentElement;

            //
            XmlNodeList nodeList = xmlRoot.GetElementsByTagName("channel");
            if (nodeList == null)
            {
                return new GooBlogSearchResult(query, 0, resultElementList.ToArray());
            }

      
            
            string strTotalNumber = GetElementString(((XmlElement)nodeList[0]).GetElementsByTagName("gooblog:searchTotalResults"));
            long totalSearchResults;
            if (string.IsNullOrEmpty(strTotalNumber))
            {
                totalSearchResults = 0;
            }
            else
            {
                totalSearchResults = long.Parse(strTotalNumber.Replace(",",""));
            }

            XmlNodeList items = xmlRoot.GetElementsByTagName("item");

            int count = 0;
            int rank = start;
            foreach (XmlElement element in items)
            {
                string title = GetElementString(element.GetElementsByTagName("title"));
                string link = GetElementString(element.GetElementsByTagName("link"));
                string description = GetElementString(element.GetElementsByTagName("description"));
                DateTime date = ParseGooDate(GetElementString(element.GetElementsByTagName("dc:date")));
                string source = GetElementString(element.GetElementsByTagName("ag:source"));
                string sourceURL = GetElementString(element.GetElementsByTagName("ag:sourceURL"));
                GooBlogElement gooElement = new GooBlogElement(title, link, description, date, source, sourceURL,rank);
                rank++;
                resultElementList.Add(gooElement);
                count++;
                if (count >= tureResultNum)
                {
                    break;
                }
            }
            System.Diagnostics.Debug.WriteLine("finish! " + requestURL);
            return new GooBlogSearchResult(query, totalSearchResults, resultElementList.ToArray());
            
            
        }

        private GooBlogSearchResult DoGooBlogSearchOver(string query, int resultNum)
        {
            int unit;
            //߂ǂ5010PʂŁD
            if (resultNum < 50)
            {
                unit = 10;
            }
            //߂ǂ50ȏ50Pʂ
            else
            {
                unit = 50;
            }

            // ʓp
            List<GooBlogElement> ResultElementList = new List<GooBlogElement>();


            int loop = (resultNum - 1) / unit;
            // ʂunitɕĎ擾
            for (int i = 0; i< loop; i++)
            {
                GooBlogSearchResult r = DoGooBlogSearch(query, 1 + i * unit, unit,unit);
                ResultElementList.AddRange(r.ResultElements);
            }
            GooBlogSearchResult gsr = DoGooBlogSearch(query, loop * unit + 1, unit, resultNum - loop * unit);
            ResultElementList.AddRange(gsr.ResultElements);

            // Ԃʂ쐬Ă悤ȂB
            return new GooBlogSearchResult(query,gsr.SearchTotalResults, ResultElementList.ToArray());
        }

        #endregion

        #region Gp\bh
        /// <summary>
        /// XmlNodeList̏߂̃m[h̃eLXg擾
        /// </summary>
        /// <param name="nodeList">XmlNodeList</param>
        /// <returns>XmlNodeList̏߂̃m[hInnerText
        ///          XmlNodeListł΋󕶎Ԃ</returns>
        private string GetElementString(XmlNodeList nodeList)
        {
            if (nodeList.Count == 0)
            {
                return string.Empty;
            }
            else
            {
                return nodeList[0].InnerText;
            }
        }


        private string MakeRequestURL(string query, int start, int resultNum)
        {
            string url = "http://blog.search.goo.ne.jp/search_goo/result/?tg=all&da=all&st=score&dp=all&bu=&ts=all&status=select" +
                "&MT=" + System.Web.HttpUtility.UrlEncode(query, System.Text.Encoding.GetEncoding("euc-jp")) + "&dc=" + resultNum.ToString() + "&fr=" + start.ToString()
            + "&rss=1";
            switch (this.sortType)
            {
                case SortType.Date:
                    url += "&st=date";
                    break;
                case SortType.Score:
                    url += "&st=score";
                    break;
            }
            return url;
        }

        /// <summary>
        /// GooBlog̍XV̕DateTime^ɕϊ
        /// </summary>
        /// <param name="strDate"></param>
        /// <returns></returns>
        private DateTime ParseGooDate(string strDate)
        {
            if (string.IsNullOrEmpty(strDate))
            {
                return new DateTime();
            }

            try
            {
                DateTime modDate = DateTime.ParseExact(strDate, "yyyy-MM-dd'T'HH:mm:sszzz", System.Globalization.DateTimeFormatInfo.InvariantInfo,
                    System.Globalization.DateTimeStyles.None);
                return modDate;
            }
            catch
            {
                return new DateTime();
            }
        }

        #endregion

        #region vpeB

        /// <summary>
        /// vNV擾Eݒ肷B
        /// </summary>
        public WebProxy Proxy
        {
            get
            {
                return this.proxy;
            }
            set
            {
                this.proxy = value;
            }
        }

        /// <summary>
        /// \[g@擾Eݒ肷
        /// </summary>
        public SortType SortBy
        {
            get
            {
                return this.sortType;
            }
            set
            {
                this.sortType = value;
            }
        }


        #endregion

        #region 񋓌^

        /// <summary>
        /// \[g@
        /// </summary>
        public enum SortType
        {
            /// <summary>
            /// Kx
            /// </summary>
            Score,
            /// <summary>
            /// XV
            /// </summary>
            Date,
        }

        #endregion
    }
}
