﻿using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.Web.Search;
using System.Runtime.Serialization;

namespace SlothLib.Web.Search
{
    /// <summary>
    /// Flickr 検索が返す検索結果全体。
    /// </summary>
    [Serializable]
    public class FlickrSearchResult : IImageSearchResult
    {

        #region コンストラクタ
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="query">検索クエリ</param>
        /// <param name="totalResultsAvailable">データ内のマッチしたクエリー数です。</param>
        /// <param name="resultElements">検索結果要素</param>
		public FlickrSearchResult(string query, long totalResultsAvailable, FlickrElement[] resultElements)
        {
            this.query = query;
            this.totalResultsAvailable = totalResultsAvailable;
            this.elementList = resultElements;
        }

        #endregion 

        #region privateフィールド

        private string query;

        private long totalResultsAvailable;
        private FlickrElement[] elementList;

        #endregion 

        #region プロパティ

        /// <summary>
        /// 検索に使われたクエリ
        /// </summary>
        public string Query
        {
            get
            {
                return this.query;
            }
        }

        /// <summary>
        /// 検索総件数
        /// </summary>
        public long TotalResultsAvailable
        {
            get
            {
                return this.totalResultsAvailable;
            }
        }

        /// <summary>
        /// この検索結果に含まれる検索結果数
        /// </summary>
        public int TotalResultsReturned
        {
            get
            {
                return this.elementList.Length;
            }
        }
        
        /*
        /// <summary>
        /// 得られた検索結果数
        /// </summary>
        public int Count
        {
            get
            {
                return this.elementList.Count;
            }
        }
        */

        /// <summary>
        ///  検索結果要素の配列
        /// </summary>
        public FlickrElement[] ResultElements
        {
            get
            {
                return elementList;
            }
        }

        #endregion 

		#region ISerializable メンバ

        /// <summary>
        /// シリアライズ化するときに呼び出される関数
        /// </summary>
        /// <param name="info">逆シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
		void System.Runtime.Serialization.ISerializable.GetObjectData(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
		{
            info.AddValue("query", this.query);
			info.AddValue("totalResultsAvailable", this.totalResultsAvailable);
			info.AddValue("elementList", this.elementList);
		}

        /// <summary>
        /// シリアライズされたものがデシリアライズされたときに呼ばれるコンストラクタ
        /// </summary>
        /// <param name="info">シリアル化に必要なすべてのデータ</param>
        /// <param name="context">シリアル化ストリームの転送元と転送先</param>
		protected FlickrSearchResult(SerializationInfo info, StreamingContext context)
		{
            this.query = info.GetString("query");
			this.totalResultsAvailable = info.GetInt64("totalResultsAvailable");
            this.elementList = (FlickrElement[])info.GetValue("elementList", typeof(FlickrElement[]));
		}

		#endregion

        #region ISearchResult メンバ

        /// <summary>
        /// 総検索数
        /// </summary>
        long ISearchResult.TotalNumber
        {
            get
            {
                return this.totalResultsAvailable;
            }
        }

        /// <summary>
        /// 検索に使われたクエリ
        /// </summary>
        string ISearchResult.Query
        {
            get
            {
                return this.query;

            }
        }

        /// <summary>
        ///  検索結果要素の配列
        /// </summary>
        ISearchResultElement[] ISearchResult.ResultElements
        {
            get
            {
                return this.ResultElements;
            }
        }

        #endregion

        #region IImageSearchResult メンバ

        /// <summary>
        /// 検索結果要素の配列
        /// </summary>
        IImageElement[] IImageSearchResult.ResultElements
        {
            get
            {
                return this.ResultElements;
            }
        }

        #endregion
    
    }
}
