using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    public partial class FormYahooJpWeb : Form
    {
        public FormYahooJpWeb()
        {
            InitializeComponent();
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            YahooJpWebSearch search = new YahooJpWebSearch("slothlib"); ;

            // ^CvZbg
            switch(cbType.Text){
                case "all":
                    search.Type = YahooJpWebSearch.SearchType.all;
                    break;
                case "any":
                    search.Type = YahooJpWebSearch.SearchType.any;
                    break;
                case "phrase":
                    search.Type = YahooJpWebSearch.SearchType.phrase;
                    break;
            }

            // FormatZbg
            switch (cbType.Text)
            {
                case "any":
                    search.Format = YahooJpWebSearch.SearchFormat.any;
                    break;
                case "html":
                    search.Format = YahooJpWebSearch.SearchFormat.html;
                    break;
                case "msword":
                    search.Format = YahooJpWebSearch.SearchFormat.msword;
                    break;
                case "pdf":
                    search.Format = YahooJpWebSearch.SearchFormat.pdf;
                    break;
                case "ppt":
                    search.Format = YahooJpWebSearch.SearchFormat.ppt;
                    break;
                case "rss":
                    search.Format = YahooJpWebSearch.SearchFormat.rss;
                    break;
                case "txt":
                    search.Format = YahooJpWebSearch.SearchFormat.txt;
                    break;
                case "xls":
                    search.Format = YahooJpWebSearch.SearchFormat.xls;
                    break;
            }

            // adultOkH
            if (cbAdultOk.Text == "true")
            {
                search.AdultOk = true;
            }
            else if (cbAdultOk.Text == "false")
            {
                search.AdultOk = false;
            }

            // similarOkH
            if (cbSimilarOk.Text == "true")
            {
                search.SimilarOk = true;
            }
            else if (cbSimilarOk.Text == "false")
            {
                search.SimilarOk = false;
            }
            
            // ̎w
            if (tbLanguage.Text != "")
            {
                search.Language = tbLanguage.Text;
            }

            // ̎w
            if (tbCountry.Text != "")
            {
                search.Country = tbCountry.Text;
            }

            // TCg̎w
            if (tbSite.Text != "")
            {
                search.Site = tbSite.Lines;
            }

            YahooJpWebSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalResultsAvailable.ToString() + "";

            lvResult.Items.Clear();
            foreach (YahooJpWebElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Rank.ToString());
                item.SubItems.Add(element.Title);
                item.SubItems.Add(element.Url);
                item.SubItems.Add(element.Summary);
                item.SubItems.Add(element.ClickUrl);
                item.SubItems.Add(element.MimeType);
                item.SubItems.Add(element.ModificationDate.ToString());
                item.SubItems.Add(element.ClickUrl);
                item.SubItems.Add(element.CacheSize.ToString());
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[2].Text);
            }
        }

        private void FormYahooJpWeb_Load(object sender, EventArgs e)
        {

        }
    }
}