﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    /// <summary>
    /// ウェブ検索テスト用のフォーム
    /// </summary>
    public partial class FormIWeb : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FormIWeb()
        {
            InitializeComponent();
            cbSearchEngine.SelectedIndex = 0;
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            IWebSearch search;
            switch (cbSearchEngine.Text)
            {
                default:
                case "YahooJpWeb":
                    search = new YahooJpWebSearch("slothlib");
                    break;
                case "LiveWebSearch":
                    search = new LiveWebSearch("2990056B93288A4723E323CAEA52B9E1931BAB03");
                    break;
                case "GoogleSOAPSearchAPI":
                    if (tbKey.Text != "")
                    {
                        search = new SlothLib.Web.Search.GoogleSOAPSearchAPI(tbKey.Text);
                    }
                    else
                    {
                        MessageBox.Show("GoogleSOAPSearch用のAPIKeyを入力してください。");
                        lvResult.Items.Clear();
                        lblTotalNumber.Text = "件";
                        return;
                    }
                    break;
            }

            IWebSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "件";

            lvResult.Items.Clear();
            foreach (IWebElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Description);
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }

        }

        private void cbMaxNum_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void cbSearchEngine_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void tbQuery_TextChanged(object sender, EventArgs e)
        {

        }

        private void lblTotalNumber_Click(object sender, EventArgs e)
        {

        }

        private void label1_Click(object sender, EventArgs e)
        {

        }

        private void lvResult_SelectedIndexChanged(object sender, EventArgs e)
        {

        }
    }
}