﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    /// <summary>
    /// ウェブ検索テスト用のフォーム
    /// </summary>
    public partial class FormIVideo : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FormIVideo()
        {
            InitializeComponent();
            cbSearchEngine.SelectedIndex = 0;
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            IVideoSearch search;
            switch (cbSearchEngine.Text)
            {
                default:
                case "YahooJpVideo":
                    search = new YahooJpVideoSearch("slothlib");
                    break;
                case "YouTubeSearch":
                    search = new YouTubeSearch("vwQ02VPFPD4");
                    break;
            }

            IVideoSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "件";

            lvResult.Items.Clear();
            foreach (IVideoElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.Duration.ToString());
                item.SubItems.Add(element.ThumbnailURL);
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }

        }
    }
}