﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using SlothLib.Web.Search;

namespace SlothLibTests.Web
{
    /// <summary>
    /// ウェブ検索テスト用のフォーム
    /// </summary>
    public partial class FormIBlog : Form
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public FormIBlog()
        {
            InitializeComponent();
            cbSearchEngine.SelectedIndex = 0;
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            IBlogSearch search;
            switch (cbSearchEngine.Text)
            {
                default:
                case "GooBlog":
                    search = new GooBlogSearch();
                    break;
            }

            IBlogSearchResult result = search.DoSearch(tbQuery.Text, int.Parse(cbMaxNum.Text));

            lblTotalNumber.Text = result.TotalNumber.ToString() + "件";

            lvResult.Items.Clear();
            foreach (IBlogElement element in result.ResultElements)
            {
                ListViewItem item = new ListViewItem(element.Title);
                item.SubItems.Add(element.URL);
                item.SubItems.Add(element.Description);
                item.SubItems.Add(element.Date.ToString());
                lvResult.Items.Add(item);
            }
        }

        private void lvResult_DoubleClick(object sender, EventArgs e)
        {
            foreach (ListViewItem item in lvResult.SelectedItems)
            {
                System.Diagnostics.Process.Start(item.SubItems[1].Text);
            }

        }
    }
}