using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.LinearAlgebra.Matrix;
using SlothLib.LinearAlgebra.Vector;

namespace SlothLibTests
{
    public partial class FormSandBoxKabutoya : Form
    {
        // 
        private const double EPS = 1.0e-10;
        // ۂߌ덷̏C
        private const int M = 15;
        // ΏۂƂȂs̍s()
        private const int N = 3;
        // őJԂ
        private const int COUNT = 200;

        // ŗLli[z
        private double[] eigenValues;
        // ŗLxNgi[z
        private BasicVector[] eigenVectors;

        public FormSandBoxKabutoya()
        {
            InitializeComponent();

            // ŗLli[z̏
            this.eigenValues = new double[N];

            // ŗLxNgi[z̏
            this.eigenVectors = new BasicVector[N];
            for (int i = 0; i < this.eigenVectors.Length; i++)
            {
                this.eigenVectors[i] = new BasicVector(N);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // ΏۂƂȂs
            BasicMatrix matrix1 = new BasicMatrix(N, N);
            // ƈ̍sB
            BasicMatrix matrix2 = new BasicMatrix(N, N);
            BasicMatrix matrix3 = new BasicMatrix(N, N);
            
            // ƈ̃xNgB
            BasicVector vector1 = new BasicVector(N);
            BasicVector vector2 = new BasicVector(N);
            BasicVector vector3 = new BasicVector(N);

            // matrix1 ɒl
            matrix1[0, 0] = Double.Parse(this.textBox2.Text);
            matrix1[0, 1] = Double.Parse(this.textBox5.Text);
            matrix1[0, 2] = Double.Parse(this.textBox8.Text);
            matrix1[1, 0] = Double.Parse(this.textBox3.Text);
            matrix1[1, 1] = Double.Parse(this.textBox6.Text);
            matrix1[1, 2] = Double.Parse(this.textBox9.Text);
            matrix1[2, 0] = Double.Parse(this.textBox1.Text);
            matrix1[2, 1] = Double.Parse(this.textBox4.Text);
            matrix1[2, 2] = Double.Parse(this.textBox7.Text);

            // matrix2 ̏l(Pʍs)Cvector1 ̏l
            for (int i = 0; i < matrix2.RowCount; i++)
            {
                for (int j = 0; j < matrix2.ColumnCount; j++)
                {
                    matrix2[i, j] = 0.0;
                }
                matrix2[i, i] = 1.0;
                vector1[i] = 1.0;
            }
            
            int sizeOfEigenValues = this.power(0, matrix1, matrix2, matrix3, vector1, vector2, vector3);
            // ŗLlȂꍇ
            if (sizeOfEigenValues == 0)
            {
                this.textBox17.Text = "ŗLl܂܂ł";
                this.showEigen(-1);
                this.comboBox1.Items.Clear();
                this.comboBox1.SelectedText = "";
            }
            // ŗLlꂽꍇ
            else
            {
                this.textBox17.Text = "";
                this.showEigen(0);
                this.comboBox1.Items.Clear();
                for (int i = 0; i < sizeOfEigenValues; i++)
                {
                    int number = i + 1;
                    this.comboBox1.Items.Add(number.ToString());
                }
                this.comboBox1.SelectedIndex = 0;
            }
        }

        /// <summary>
        /// őŗLlׂ@ŋ߂D
        /// </summary>
        /// <param name="indexOfEigenValues">Ԗڂ̌ŗLl</param>
        /// <param name="matrix1">Ώۍs</param>
        /// <param name="matrix2">ŏ͒Pʍs̍ƈ</param>
        /// <param name="matrix3">ƈ</param>
        /// <param name="vector1">ŗLxNg̏l</param>
        /// <param name="vector2">ƈ</param>
        /// <param name="vector3">ƈ</param>
        /// <returns>܂ŗLl̐</returns>
        private int power(int indexOfEigenValues, BasicMatrix matrix1, BasicMatrix matrix2, 
            BasicMatrix matrix3, BasicVector vector1, BasicVector vector2, BasicVector vector3)
        {
            double l1, l2, x;
            int numberOfEigenValues, k, k1;

            numberOfEigenValues = indexOfEigenValues;
            k = 0;
            l1 = 0.0;

            for (int i = 0; i < vector1.Dimension; i++)
            {
                l1 += Math.Pow(vector1[i], 2.0);
                vector2[i] = vector1[i];
            }
            l1 = Math.Sqrt(l1);

            // JԂvZ
            while (k < COUNT)
            {
                // ۂߌ덷C
                if (k % M == 0)
                {
                    l2 = 0.0;
                    for (int i = 0; i < vector3.Dimension; i++)
                    {
                        vector3[i] = 0.0;
                        for (int j = 0; j < vector2.Dimension; j++)
                        {
                            vector3[i] += matrix2[i, j] * vector2[j];
                        }
                        l2 = Math.Pow(vector3[i], 2.0);
                    }
                    l2 = Math.Sqrt(l2);
                    for (int i = 0; i < vector3.Dimension; i++)
                    {
                        vector2[i] = vector3[i] / l2;
                    }
                }

                // ̋ߎ
                l2 = 0.0;
                for (int i = 0; i < vector3.Dimension; i++)
                {
                    vector3[i] = 0.0;
                    for (int j = 0; j < vector2.Dimension; j++)
                    {
                        vector3[i] += matrix1[i, j] * vector2[j];
                    }
                    l2 += Math.Pow(vector3[i], 2.0);
                }
                l2 = Math.Sqrt(l2);
                for (int i = 0; i < vector3.Dimension; i++)
                {
                    vector3[i] /= l2;
                }

                // 
                // ꍇ
                if (Math.Abs((l2 - l1) / l1) < EPS)
                {
                    k1 = -1;
                    for (int i = 0; (i < vector3.Dimension) && (k1 < 0); i++)
                    {
                        if (Math.Abs(vector3[i]) > 0.001)
                        {
                            k1 = i;
                            if (vector3[k1] * vector2[k1] < 0.0)
                            {
                                l2 = -l2;
                            }
                        }
                    }

                    k = COUNT;
                    this.eigenValues[indexOfEigenValues] = l2;

                    for (int i = 0; i < vector3.Dimension; i++)
                    {
                        this.eigenVectors[indexOfEigenValues][i] = vector3[i];
                    }

                    if (indexOfEigenValues == matrix1.ColumnCount - 1)
                    {
                        numberOfEigenValues = indexOfEigenValues + 1;
                    }
                    else
                    {
                        for (int i1 = 0; i1 < matrix3.RowCount; i1++)
                        {
                            for (int i2 = 0; i2 < matrix3.ColumnCount; i2++)
                            {
                                matrix3[i1, i2] = default(double);
                                for (int i3 = 0; i3 < matrix1.ColumnCount; i3++)
                                {
                                    x = (i1 == i3) ? matrix1[i1, i3] - l2 : matrix1[i1, i3];
                                    matrix3[i1, i2] += x * matrix2[i3, i2];
                                }
                            }
                        }
                        matrix2 = (BasicMatrix)matrix3.Clone();
                        for (int i = 0; i < matrix2.RowCount; i++)
                        {
                            vector2[i] = default(double);
                            for (int j = 0; j < matrix2.ColumnCount; j++)
                            {
                                vector2[i] += matrix2[i, j] * vector1[j];
                            }
                        }
                        vector1 = (BasicVector)vector2.Clone();

                        numberOfEigenValues = this.power(indexOfEigenValues + 1, matrix1, matrix2, matrix3, vector1, vector2, vector3);
                    }
                }
                // Ȃꍇ
                else
                {
                    vector2 = (BasicVector)vector3.Clone();
                    l1 = l2;
                    k++;
                }
            }

            return numberOfEigenValues;
        }

        private void showEigen(int index)
        {
            if (index >= 0)
            {
                // ŗLl̕\
                this.textBox13.Text = ToHalfAdjust(this.eigenValues[index], 2).ToString();

                // ŗLxNg̕\
                this.textBox12.Text = ToHalfAdjust(this.eigenVectors[index][0], 2).ToString();
                this.textBox16.Text = ToHalfAdjust(this.eigenVectors[index][0], 2).ToString();
                this.textBox10.Text = ToHalfAdjust(this.eigenVectors[index][1], 2).ToString();
                this.textBox14.Text = ToHalfAdjust(this.eigenVectors[index][1], 2).ToString();
                this.textBox11.Text = ToHalfAdjust(this.eigenVectors[index][2], 2).ToString();
                this.textBox15.Text = ToHalfAdjust(this.eigenVectors[index][2], 2).ToString();
            }
            else
            {
                this.textBox13.Text = "";
                this.textBox12.Text = "";
                this.textBox16.Text = "";
                this.textBox10.Text = "";
                this.textBox14.Text = "";
                this.textBox11.Text = "";
                this.textBox15.Text = "";
            }
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            int index = Int32.Parse(this.comboBox1.SelectedItem.ToString()) - 1;
            this.showEigen(index);
        }

        private double ToHalfAdjust(double doubleValue, int intDigits)
        {
            double doubleCoef = System.Math.Pow(10, intDigits);

            return (doubleValue > 0) ? System.Math.Floor((doubleValue * doubleCoef) + 0.5) / doubleCoef :
                                System.Math.Ceiling((doubleValue * doubleCoef) - 0.5) / doubleCoef;
        }
    }
}