using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlothLib.NLP;

namespace SlothLibTests.NLP
{
    public partial class FormNLPChaSen : Form
    {
        public FormNLPChaSen()
        {
            InitializeComponent();
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            ChaSen chaSen = new ChaSen();
            ChaSenResult result = chaSen.DoAnalyze(rtbInput.Text);
            lvResult.Items.Clear();
            foreach (ChaSenMorpheme morpheme in result.Morphemes)
            {
                ListViewItem item = new ListViewItem(morpheme.Raw);
                item.SubItems.Add(morpheme.Original);
                item.SubItems.Add(morpheme.POS);
                item.SubItems.Add(morpheme.ConjugationPattern);
                item.SubItems.Add(morpheme.ConjugationForm);
                item.SubItems.Add(morpheme.Reading);
                lvResult.Items.Add(item);
            }
        }
    }
}