using System;
using System.Collections.Generic;
using System.Text;
using SlothLib.LinearAlgebra.Matrix;
using STATCONNECTORSRVLib;

namespace SlothLib.PlatForm.R.LinearAlgebra.Matrix
{

    public class InvertibleMatrix : StandaloneMatrix
    {
        public InvertibleMatrix(IMatrix matrix)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            if (matrix.RowCount == matrix.ColumnCount)
            {
                ROperator.Set("m", matrix.GetPlainMatrix());

                try
                {
                    ROperator.Run("r<-solve(m)");

                    BasicMatrix tmpMatrix = new BasicMatrix(ROperator.Run("r") as double[,]);

                    for (int i = 0; i < this.RowCount; i++)
                    {
                        for (int j = 0; j < this.ColumnCount; j++)
                        {
                            this[i, j] = tmpMatrix[i, j];
                        }
                    }
                }
                catch (System.Runtime.InteropServices.COMException ex)
                {
                    // ONƑSvf0̍sԂĂ܂
                    System.Diagnostics.Debug.WriteLine(ex.Message); 
                }

                ROperator.Close();
            }
        }

    }
}
