﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.NLP
{
    /// <summary>
    /// SSTaggerの結果クラス
    /// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-10-03][inagawa]作成</newpara>
    /// </remarks>
    public class SSTaggerResult : IMorphologicalAnalyzerResult
    {
        #region private

        private List<Morpheme> morphemeList;

        //GetOriginalArray()等を実装するためのフィルタ
        private static RemainOriginalFilter remainOriginalFilter = new RemainOriginalFilter();
        private static RemainPosFilter remainPosFilter = new RemainPosFilter();
        private static RemainRawFilter remainRawFilter = new RemainRawFilter();

        #endregion

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="morphemes">もととなるIEnumerable</param>
        public SSTaggerResult(IEnumerable<Morpheme> morphemes)
        {
            this.morphemeList = new List<Morpheme>(morphemes);
        }


        /// <summary>
        /// 格納する形態素の配列
        /// </summary>
        public Morpheme[] Morphemes
        {
            get { return this.morphemeList.ToArray(); }
        }

        #region IMorphologicalAnalyzerResult メンバ

        IMorpheme[] IMorphologicalAnalyzerResult.Morphemes
        {
            get { return this.morphemeList.ToArray(); }
        }

        /// <summary>
        /// 各形態素のRawを配列にして返す
        /// </summary>
        /// <returns>Rawの配列</returns>
        public string[] GetRawArray()
        {
            return remainRawFilter.DoFilter(this.Morphemes);
        }

        /// <summary>
        /// 各形態素のOriginalを配列にして返す
        /// </summary>
        /// <returns>Originalの配列</returns>
        public string[] GetOriginalArray()
        {
            return remainOriginalFilter.DoFilter(this.Morphemes);
        }

        /// <summary>
        /// 各形態素のPOSを配列にして返す
        /// </summary>
        /// <returns>POSの配列</returns>
        public string[] GetPOSArray()
        {
            return remainPosFilter.DoFilter(this.Morphemes);
        }

        #endregion
    }
}
