using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Kw^NX^OsNX̒ۃNX
	/// </summary>
	public abstract class HierarchicalClustering<T> : IHierarchicalClustering<T>
	{
		// <summary>
		// ̍Œl
		// </summary>
		//public const double INFINITE_DISTANCE = System.Double.MaxValue;

		/// <summary>
		/// e[ǔvZ
		/// </summary>
		protected ICalculatorScalarFromTwoVectors<T> calculator;

		/// <summary>
		/// e[ǔvZ^Cv
		/// </summary>
		protected ClusteringDistanceType dType;



		/// <summary>
		/// e[u쐬ɗp
		/// </summary>
		/// <param name="distanceCalculator"></param>
		public HierarchicalClustering(IDistanceCalculator<T> distanceCalculator)
		{
			this.calculator = distanceCalculator;
			this.dType = ClusteringDistanceType.Distance;
		}

		/// <summary>
		/// ގxe[u쐬ɗp
		/// </summary>
		/// <param name="similarityCalculator"></param>
		public HierarchicalClustering(ISimilarityCalculator<T> similarityCalculator)
		{
			this.calculator = similarityCalculator;
			this.dType = ClusteringDistanceType.Similarity;
		}


		/// <summary>
		/// NX^OۂɍsNXԂ
		/// </summary>
		/// <param name="vectors"></param>
		/// <returns></returns>
		protected abstract IHierarchicalClusteringProcess<T> GetProcess(IVector<T>[] vectors);


		/// <summary>
		/// NX^̐wlɂȂ邩Ã݂NX^̋wl艓Ȃ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="thresholdClusterCount">NX^O~߂臒lƂȂNX^</param>
		/// <param name="thresholdDistanceOrSimilarity">NX^O~߂臒lƂȂ鋗܂͗ގx</param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors, int thresholdClusterCount, double thresholdDistanceOrSimilarity)
		{
			IHierarchicalClusteringProcess<T> process = GetProcess(vectors);
			return process.DoClustering(thresholdClusterCount, thresholdDistanceOrSimilarity);
		}

		/// <summary>
		/// NX^1ɂȂ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors)
		{
			IHierarchicalClusteringProcess<T> process = GetProcess(vectors);
			return process.DoClustering();
		}

		/// <summary>
		/// NX^̐wlɂȂ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="thresholdClusterCount"></param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors, int thresholdClusterCount)
		{
			IHierarchicalClusteringProcess<T> process = GetProcess(vectors);
			return this.DoClustering(vectors, thresholdClusterCount);
		}

		/// <summary>
		/// ݂̃NX^̋wl艓Ȃ܂ŊKwINX^Os
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="thresholdDistanceOrSimilarity"></param>
		/// <returns></returns>
		public HierarchicalClusteringResult<T> DoClustering(IVector<T>[] vectors, double thresholdDistanceOrSimilarity)
		{
			IHierarchicalClusteringProcess<T> process = GetProcess(vectors);
			return this.DoClustering(vectors, thresholdDistanceOrSimilarity);
		}

	}
}
