using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// Qϖ@
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class GroupAverageClusteringProcess<T> : HierarchicalClusteringProcess<T>
	{

		/// <summary>
		/// ̃NX^ɑĂACe̐i[Ă
		/// </summary>
		protected int[] itemCountInCluster;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="vectors"></param>
		/// <param name="calculator"></param>
		/// <param name="dType"></param>
		public GroupAverageClusteringProcess(IVector<T>[] vectors, ICalculatorScalarFromTwoVectors<T> calculator, ClusteringDistanceType dType)
			: base(vectors, calculator, dType)
		{
			itemCountInCluster = new int[this.itemCount];
			for (int i = 0; i < this.itemCount; i++)
			{
				// ͂߂͑S1B
				itemCountInCluster[i] = 1;
			}
		}
		
		/// <summary>
		/// NX^
		/// </summary>
		/// <param name="cid1"></param>
		/// <param name="cid2"></param>
		protected override void Union(int cid1, int cid2)
		{
			// NX^ԍ̍XV
			clusterID[cid2] = cid1;

			// ACe̍XV
			int c = itemCountInCluster[cid1] + itemCountInCluster[cid2];
			itemCountInCluster[cid1] = c;

			// e[u̍XV
			for (int i = 0; i < this.itemCount; i++)
			{
				// NX^̑\ł͂ȂAe[ȗΊp͍XVEQƂ̑Ώۂł͂ȂB
				if (clusterID[i] != i || i == cid1 || i == cid2)
				{
					continue;
				}
				SetDistance(cid1, i, (GetDistance(i, cid1) * this.itemCountInCluster[cid1] + GetDistance(i, cid2) * this.itemCountInCluster[cid2]) / (this.itemCountInCluster[cid1] + this.itemCountInCluster[cid2]));
			}
		}

	}
}
