﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 要素の重みの総和が1になるように正規化
	/// Value = Value / Sum
	/// </summary>
	public class SumNormVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public SumNormVector(IVector<T> vector)
		{
			double sum = VectorOperator<T>.GetAllElementSum(vector);

			foreach (T key in vector.Keys)
			{
				if (sum != 0)
				{
					this[key] = vector[key] / sum;
				}
				else
				{
					this[key] = 0;
				}
			}
		}
	}
}
