﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 減算の結果を返すベクトル
	/// </summary>
	/// <typeparam name="T"></typeparam>

	public class SubtractVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		public SubtractVector(IVector<T> vector1, IVector<T> vector2)
		{
			Calculate(vector1, vector2);
		}

		private void Calculate(IVector<T> vector1, IVector<T> vector2)
		{
			foreach (T key in vector1.Keys)
			{
				this[key] = vector1[key];
			}

			foreach (T key in vector2.Keys)
			{
				this[key] -= vector2[key];
			}
		}
	}
}
