﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 乗算
	/// Value = multiplyValue * Value1 * Value2 * ...
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class MultiplyVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vectors"></param>
		public MultiplyVector(IEnumerable<IVector<T>> vectors)
		{
			Calculate(1.0, vectors);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vectors"></param>
		public MultiplyVector(params IVector<T>[] vectors)
		{
			Calculate(1.0, vectors);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="multiplyValue"></param>
		/// <param name="vectors"></param>
		public MultiplyVector(double multiplyValue, IEnumerable<IVector<T>> vectors)
		{
			Calculate(multiplyValue, vectors);
		}

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="multiplyValue"></param>
		/// <param name="vectors"></param>
		public MultiplyVector(double multiplyValue, params IVector<T>[] vectors)
		{
			Calculate(multiplyValue, vectors);
		}

		private void Calculate(double multiplyValue, IEnumerable<IVector<T>> vectors)
		{
			IEnumerator<IVector<T>> en = vectors.GetEnumerator();
			en.MoveNext();
			IVector<T> first = en.Current;

			if (first == null)
				return ;

			foreach (T key in first.Keys)
			{
				this[key] = multiplyValue;

				foreach (IVector<T> v in vectors)
				{
					this[key] *= v[key];
				}
			}
		}
	}
}
