﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 最大の要素の重みが1になるように正規化
	/// Value = Value / Max
	/// </summary>
	/// <typeparam name="T"></typeparam>
	public class MaxNormVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		public MaxNormVector(IVector<T> vector)
		{
			double absmax = VectorOperator<T>.GetMaxNorm(vector);

			foreach (T key in vector.Keys)
			{
				if (absmax != 0)
				{
					this[key] = vector[key] / absmax;
				}
				else
				{
					this[key] = 0;
				}
			}
		}
	}
}
