﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 対数
	/// Value = Log(Value + addValue)
	/// ただし、元のValueが0以上の時のみ上記の値が計算される。
	/// スタンドアロン版
	/// </summary>
	public class LogVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// baseValue = 2.0
		/// addValue = 1.0
		/// </summary>
		/// <param name="vector"></param>
		public LogVector(IVector<T> vector)
			: this(vector, 2.0, 1.0)
		{ }

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		/// <param name="baseValue">logの基底</param>
		/// <param name="addValue">logする前に加算する値</param>
		public LogVector(IVector<T> vector, double baseValue, double addValue)
		{
			foreach (T key in vector.Keys)
			{
				if (vector[key] <= 0)
				{
					this[key] = Math.Log(addValue + vector[key], baseValue);
				}
				else
				{
					this[key] = Math.Log(vector[key], baseValue);
				}
			}
		}

	}
}
