﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 全てのベクトルクラスの基本となるインターフェース
	/// </summary>
    /// <remarks>
    /// 
    /// <newpara>[2007-11-12][kabutoya]修正</newpara>
    /// </remarks>
	public interface IVector<T> : ICloneable
	{
		/// <summary>
		/// 指定した次元における値。
		/// </summary>
		double this[T key]
		{
			get;
			set;
		}

		/// <summary>
		/// ベクトルの次元となるキー一覧
		/// </summary>
		Dictionary<T, double>.KeyCollection Keys
		{
			get;
		}

		/// <summary>
		/// ベクトルにある要素のうち、0以外の値をもつ要素の一覧を取得する。
		/// </summary>
		T[] KeyList
		{
			get;
		}

        /// <summary>
        /// ベクトル中の値が 0 でない要素の数を取得する。
        /// </summary>
        int Count
        {
            get;
        }

		/// <summary>
		/// ソートされた要素のリスト
		/// </summary>
		/// <returns>ベクトルの重みが降順にソートされたKeyList</returns>
		T[] GetSortedKeyList();

        /// <summary>
        /// ベクトルがkeyの次元を持つかどうかを返す
        /// </summary>
        /// <param name="key">持つかどうか確かめたい次元となるkey</param>
        /// <returns>持つ場合はtrue，持たない場合はfalse</returns>
        bool ContainsKey(T key);
	}
}
