﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// 長さが1になるように正規化
	/// Value = Value / Length
	/// </summary>
	public class CosNormVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		public CosNormVector(IVector<T> vector)
		{
			double vectorLength = VectorOperator<T>.GetEuclideanDistance(vector);

			foreach (T key in vector.Keys)
			{
				this[key] = vector[key] / vectorLength;
			}
		}
	}
}
