﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// バイナリ化
	/// Value = (Value != 0) ? 1.0 : 0.0
	/// </summary>
	public class BinaryVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		public BinaryVector(IVector<T> vector)
		{
			foreach (T key in vector.Keys)
			{
				this[key] = (vector[key] != 0) ? 1.0 : 0.0;
			}
		}
	}
}
