﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.FeatureVector
{
	/// <summary>
	/// MaxNormの修正版
	/// 重みが0ではない要素に対して0.5以上の重みを保証する
	/// Value = (0.5 + 0.5 * MaxNorm(Value))
	/// </summary>

	public class AugNormVector<T> : BasicVector<T>
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="vector"></param>
		public AugNormVector(IVector<T> vector)
		{
			double absmax = VectorOperator<T>.GetMaxNorm(vector);

			foreach (T key in vector.Keys)
			{
				if (absmax != 0)
				{
					this[key] = 0.5 + 0.5 * vector[key] / absmax;
				}
				else
				{
					this[key] = 0;
				}
			}
		}
	}
}
