using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
	/// <summary>
	/// ]us߂NX
    /// Value[i, j] = Value[j, i];
	/// </summary>
	public class TransposedMatrix : BasicMatrix
    {
        #region RXgN^

        /// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="matrix"></param>
		public TransposedMatrix(IMatrix matrix)
			: base(matrix.ColumnCount, matrix.RowCount)
		{
            this.calculate(matrix);
        }

        #endregion

        private void calculate(IMatrix matrix)
        {
            for (int i = 0; i < this.RowCount; i++)
            {
                for (int j = 0; j < this.ColumnCount; j++)
                {
                    this[i, j] = matrix[j, i];
                }
            }
        }
    }
}
