using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
    /// <summary>
    /// vf̒l̑a1ɂȂ悤ɐK
    /// Value = Value / Sum
    /// </summary>
    public class SumNormMatrix : BasicMatrix
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="matrix"></param>
        public SumNormMatrix(IMatrix matrix)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            double sum = MatrixOperator.GetAllElementSum(matrix);

            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    if (sum != 0.0)
                    {
                        this[i, j] = matrix[i, j] / sum;
                    }
                    else
                    {
                        this[i, j] = default(double);
                    }
                }
            }
        }
    }
}
