using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
    /// <summary>
    /// ݏ
    /// Value = Value ^ exponent
    /// </summary>
    public class PowerMatrix : BasicMatrix
    {
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="matrix"></param>
        /// <param name="exponent"></param>
        public PowerMatrix(IMatrix matrix, double exponent)
            : base(matrix.RowCount, matrix.ColumnCount)
        {
            for (int i = 0; i < matrix.RowCount; i++)
            {
                for (int j = 0; j < matrix.ColumnCount; j++)
                {
                    this[i, j] = Math.Pow(matrix[i, j], exponent);
                }
            }
        }
    }
}
