using System;
using System.Collections.Generic;
using System.Text;

namespace SlothLib.LinearAlgebra.Matrix
{
	/// <summary>
	/// s̕
    /// Value = -Value;
	/// </summary>
	public class NegateMatrix : BasicMatrix
	{
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="matrix"></param>
		public NegateMatrix(IMatrix matrix)
			: base(matrix.RowCount, matrix.ColumnCount)
		{
			for (int i = 0; i < this.RowCount; i++)
			{
				for (int j = 0; j < this.ColumnCount; j++)
				{
					this[i, j] = -matrix[i, j];
				}
			}
		}
	}
}
