using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace SlothLib.IO
{
	/// <summary>
	/// lXȌ`̓̕ê݂ǂݍށB
	/// xdoc2txt𗘗pB
	/// </summary>
	public class MultiReader : IContentReader
	{

		private TextReader textReader;
		private Xdoc2txtReader xdoc2txtReader;
		private Xdoc2txtHtmlReader xdoc2txtHtmlReader;



		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="xdoc2txtExePath"></param>
		public MultiReader(string xdoc2txtExePath)
        {
			this.textReader = new TextReader();
			this.xdoc2txtReader = new Xdoc2txtReader(xdoc2txtExePath);
			this.xdoc2txtHtmlReader = new Xdoc2txtHtmlReader(xdoc2txtExePath);
        }


        /// <summary>
        /// ẽeLXg̓ǂݍ
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public string Read(string filePath)
        {
            // t@C̗L`FbN
            if (!System.IO.File.Exists(filePath))
            {
                throw new System.IO.FileNotFoundException("t@C݂܂B");
            }

            // gq"."tŏŎ擾
            string fileExt = filePath.Substring(filePath.LastIndexOf(".")).ToLower();

            try
            {
                // eLXgt@C
                if (fileExt.Equals(".txt"))
                {
                    return (new SlothLib.IO.TextReader()).Read(filePath);
                }

                // htm ܂ html
                if (fileExt.Equals(".htm") || fileExt.Equals(".html"))
                {
					return this.xdoc2txtHtmlReader.Read(filePath);
                }

                // Xdoc2txtihtmȊOj
                if (this.xdoc2txtReader.IsReadable(fileExt))
                {
                    return this.xdoc2txtReader.Read(filePath);
                }
            }
            catch
            {
                throw;
            }
            throw new ApplicationException("MultiReaderł͓ǂݍ݂ł܂łB");
        }

		/// <summary>
		/// 
		/// </summary>
		/// <param name="extension"></param>
		/// <returns></returns>
		public bool IsReadable(string extension)
		{
			return (this.xdoc2txtReader.IsReadable(extension) || extension.Equals(".txt") || extension.Equals(".htm"));
		}

	}
}
