using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;
using System.Text.RegularExpressions;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.Serialization;

namespace SlothLib.Web.WebLoader
{
    /// <summary>
    /// URL̓e擾NX
    /// </summary>
    public class WebGet
    {
        private WebProxy proxy;
        private string userAgent;

        /// <summary>
        /// RXgN^
        /// </summary>
        public WebGet()
        {
            this.proxy = null;
            this.userAgent = string.Empty;
        }


        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="url">f[^擾URL</param>
        /// <param name="outputName">ۑt@C</param>
        /// <returns>WebGetResult^̎擾</returns>
        public WebGetResult DoFetch(string url, string outputName)
        {
            return this.DoFetch(url, outputName, null, null);
        }

       
        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="url">f[^擾URL</param>
        /// <returns>WebGetResult^̎擾</returns>
        public WebGetResult DoFetch(string url)
        {
            return this.DoFetch(url,null,null);
        }
        
        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="url">f[^擾URL</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        /// <returns>WebGetResult^̎擾</returns>
        public WebGetResult DoFetch(string url, string[] allowContentTypes, string[] excludeContentTypes)
        {
            return  this.DoFetch(url,GetTempFileName(url), allowContentTypes, excludeContentTypes);
        }

        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        /// <returns></returns>
        public MultiWebGetResults DoFetch(string[] urlList, string[] allowContentTypes, string[] excludeContentTypes)
        {
            string[] tmpFileNameList = new string[urlList.Length];

            for (int i = 0; i < urlList.Length; i++)
            {
                tmpFileNameList[i] = GetTempFileName(urlList[i]);
            }

            return this.DoFetch(urlList, tmpFileNameList, allowContentTypes, excludeContentTypes);
        }

        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <returns>MultiWebGetResults^̌</returns>
        public MultiWebGetResults DoFetch(string[] urlList)
        {
            return this.DoFetch(urlList, null, null);
        }


        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="url">擾URL</param>
        /// <param name="outputName">o̓t@C</param>
        /// <param name="allowContentTypes">擾URLContentType</param>
        /// <param name="excludeContentTypes">OURLContentTypẽXg</param>
        /// <returns>WebGetResult^̎擾</returns>
        public WebGetResult DoFetch(string url, string outputName, string[] allowContentTypes, string[] excludeContentTypes)
        {
            string status = "";
            
            // ǂݍݗpobt@
            byte[] buf;

            // wb_
            HttpHeader header = new HttpHeader();

            // ǍJn܂B
            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
            if (this.proxy != null)
            {
                req.Proxy = this.proxy;
            }
            if (!string.IsNullOrEmpty(this.userAgent))
            {
                //UserAgent̐ݒ
                req.UserAgent = this.userAgent;
            }

            try
            {
                using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
                using (Stream st = res.GetResponseStream())
                using (BinaryReader br = new BinaryReader(st))
                using (FileStream fs = new FileStream(outputName, FileMode.Create))
                using (BinaryWriter bw = new BinaryWriter(fs))
                {

                     status = res.StatusDescription;

                    // Rec^Cv͕Kvł̂ŁB
                    string contentType = res.ContentType;
                    string mainType = contentType.Substring(0, contentType.IndexOf("/"));
                    // GR[h񂪊܂܂ē΁A菜B
                    int lEncoding = contentType.IndexOf(";");
                    if (lEncoding >= 0)
                    {
                        contentType = contentType.Substring(0, lEncoding);
                    }

                    // wb_l
                    header = new HttpHeader(
                        res.CharacterSet, res.ContentEncoding, res.ContentLength, 
						//res.ContentType,
						contentType,
                        res.Cookies, res.LastModified, res.Method, res.ProtocolVersion,
                        res.ResponseUri, res.Server, res.StatusCode, res.StatusDescription);

                    // Rec^CvΏۂ̂̂ǂׂB

                    if (allowContentTypes != null)
                    {
                        List<string> allowList = new List<string>();
                        allowList.AddRange(allowContentTypes);
                        //ΏۂȂCnullԂ
                        if (!allowList.Contains(contentType) && !allowList.Contains(mainType))
                        {
                            return null;
                        }
                    }

                    // Rec^CvΏۊOǂ𒲂ׂB
                    if (excludeContentTypes != null)
                    {
                        List<string> excludeList = new List<string>();
                        excludeList.AddRange(excludeContentTypes);
                        //OΏۂłnullԂ
                        if (excludeList.Contains(contentType) || excludeList.Contains(mainType))
                        {
                            return null;
                        }
                    }

                    // oCiŃt@Cɏo
                    while (true)
                    {
                        buf = br.ReadBytes(8192);
                        if (buf.Length == 0)
                        {
                            break;
                        }
                        bw.Write(buf);
                    }
                }
            }
            catch (WebException ex)
            {
                status += ex.Message;
            }
            catch (Exception ex)
            {
                //ł܂
                System.Diagnostics.Debug.WriteLine(ex.Message);
            }

            // ʂ쐬
            WebGetResult re = new WebGetResult(url, outputName, header, status);

            //Debug.WriteLine("Response: "+status);
            return re;
        }

        /// <summary>
        /// URL̃f[^擾
        /// </summary>
        /// <param name="urlList">f[^擾URL̃Xg</param>
        /// <param name="outputFileList">擾URL̃XgɑΉo̓t@C̃Xg</param>
        /// <param name="allowContentTypes">擾URLCotentTypẽXg</param>
        /// <param name="excludeContentTypes">擾ȂURLCotentTypẽXg</param>
        public MultiWebGetResults DoFetch(string[] urlList, string[] outputFileList, string[] allowContentTypes, string[] excludeContentTypes)
        {
            List<WebGetResult> resultElements = new List<WebGetResult>();

            if (urlList.Length < outputFileList.Length)
            {
                System.Diagnostics.Debug.WriteLine("WebGet:擾URLXgƑΉo̓t@CXg̗vfΉĂ܂");
                return null;
            }
            
            for (int index = 0; index < urlList.Length; index++)
            {
                string url = urlList[index];
                string outputFile = outputFileList[index];

                WebGetResult result = this.DoFetch(url, outputFile, allowContentTypes, excludeContentTypes);
                resultElements.Add(result);
            }
            return new MultiWebGetResults(resultElements.ToArray());
        }


        /// <summary>
        /// URLӂ̃t@C𓾂
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private string GetHashName(string url)
        {
            return url.GetHashCode().ToString() + DateTime.Now.GetHashCode() + ".tmp";
        }

        /// <summary>
        /// URLꎞt@C𓾂
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        private string GetTempFileName(string url)
        {
            return Path.GetTempPath() + GetHashName(url);
        }

        /// <summary>
        /// HTTPʐMɗpproxyT[o
        /// </summary>
        public string Proxy
        {
            set
            {
                if (value != null)
                {
                    this.proxy = new WebProxy(value);
                }
                else
                {
                    this.proxy = null;
                }
            }
            get
            {
                if (this.proxy != null)
                {
                    return this.proxy.Address.AbsoluteUri;
                }
                else
                {
                    return "";
                }
            }
        }

        /// <summary>
        /// HTTPʐMɗpUserAgent
        /// </summary>
        public string UserAgent
        {
            set
            {
                this.userAgent = value;
            }
            get
            {
                return this.userAgent;
            }
        }
    }
}
