using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;
using System.Runtime.Serialization;

namespace SlothLib.Web.WebLoader
{
    /// <summary>
    /// HTTPwb_ۑ
    /// </summary>
    [Serializable]
    public struct HttpHeader : ISerializable
    {
        private string characterSet;
        private string contentEncoding;
        private long contentLength;
        private string contentType;
        private CookieCollection cookies;
        private DateTime lastModified;
        private string method;
        private Version protocolVersion;
        private Uri responseUri;
        private string server;
        private HttpStatusCode statusCode;
        private string statusDescription;

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="characterSet"></param>
        /// <param name="contentEncoding"></param>
        /// <param name="contentLength"></param>
        /// <param name="contentType"></param>
        /// <param name="cookies"></param>
        /// <param name="lastModified"></param>
        /// <param name="method"></param>
        /// <param name="protocolVersion"></param>
        /// <param name="responseUri"></param>
        /// <param name="server"></param>
        /// <param name="statusCode"></param>
        /// <param name="statusDescription"></param>
        public HttpHeader(
            string characterSet,
            string contentEncoding,
            long contentLength,
            string contentType,
            CookieCollection cookies,
            DateTime lastModified,
            string method,
            Version protocolVersion,
            Uri responseUri,
            string server,
            HttpStatusCode statusCode,
            string statusDescription)
        {
            this.characterSet = characterSet;
            this.contentEncoding = contentEncoding;
            this.contentLength = contentLength;
            this.contentType = contentType;
            this.cookies = cookies;
            this.lastModified = lastModified;
            this.method = method;
            this.protocolVersion = protocolVersion;
            this.responseUri = responseUri;
            this.server = server;
            this.statusCode = statusCode;
            this.statusDescription = statusDescription;
        }
        /// <summary>
        /// CharacterSet
        /// </summary>
        public string CharacterSet
        {
            get { return this.characterSet; }
        }
        /// <summary>
        /// ContentEncoding
        /// </summary>
        public string ContentEncoding
        {
            get { return this.contentEncoding; }
        }
        /// <summary>
        /// ContentLength
        /// </summary>
        public long ContentLength
        {
            get { return this.contentLength; }
        }
        /// <summary>
        /// ContentType
        /// </summary>
        public string ContentType
        {
            get { return this.contentType; }
        }
        /// <summary>
        /// Cookies
        /// </summary>
        public CookieCollection Cookies
        {
            get { return this.cookies; }
        }
        /// <summary>
        /// LastModified
        /// </summary>
        public DateTime LastModified
        {
            get { return this.lastModified; }
        }
        /// <summary>
        /// Method
        /// </summary>
        public string Method
        {
            get { return this.method; }
        }
        /// <summary>
        /// ProtocolVersion
        /// </summary>
        public Version ProtocolVersion
        {
            get { return this.protocolVersion; }
        }
        /// <summary>
        /// ResponseUri
        /// </summary>
        public Uri ResponseUri
        {
            get { return this.responseUri; }
        }
        /// <summary>
        /// Server
        /// </summary>
        public string Server
        {
            get { return this.server; }
        }
        /// <summary>
        /// StatusCode
        /// </summary>
        public HttpStatusCode StatusCode
        {
            get { return this.statusCode; }
        }
        /// <summary>
        /// StatusDescription
        /// </summary>
        public string StatusDescription
        {
            get { return this.statusDescription; }
        }

        /// <summary>
        /// HttpHeader̓e\
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {

            StringBuilder sb = new StringBuilder();
            sb.AppendLine("characterSetF" + this.characterSet);
            sb.AppendLine("contentEncodingF" + this.contentEncoding);
            sb.AppendLine("contentLengthF" + this.contentLength);
            sb.AppendLine("contentTypeF" + this.contentType);
            sb.AppendLine("cookiesF" + this.cookies.ToString());
            sb.AppendLine("lastModifiedF" + this.lastModified);
            sb.AppendLine("methodF" + this.method);
            sb.AppendLine("responseUriF" + this.responseUri);
            sb.AppendLine("serverF" + this.server);
            sb.AppendLine("statusCodeF" + this.statusCode);
            sb.AppendLine("statusDescriptionF" + this.statusDescription);

            return sb.ToString();
        }

        #region ISerializable o

        /// <summary>
        /// VACYƂɌĂяo֐
        /// </summary>
        /// <param name="info">tVAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
        void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("characterSet", this.characterSet);
            info.AddValue("contentEncoding", this.contentEncoding);
            info.AddValue("contentLength", this.contentLength);
            info.AddValue("contentType", this.contentType);
            info.AddValue("cookies", this.cookies);
            info.AddValue("lastModified", this.lastModified);
            info.AddValue("method", this.method);
            info.AddValue("protocolVersion", this.protocolVersion);
            info.AddValue("responseUri", this.responseUri);
            info.AddValue("server", this.server);
            info.AddValue("statusCode", this.statusCode);
            info.AddValue("statusDescription", this.statusDescription);
        }

        /// <summary>
        /// VACYꂽ̂fVACYꂽƂɌĂ΂RXgN^
        /// </summary>
        /// <param name="info">VAɕKvȂׂẴf[^</param>
        /// <param name="context">VAXg[̓]Ɠ]</param>
        public HttpHeader(SerializationInfo info, StreamingContext context)
        {
            this.characterSet = info.GetString("characterSet");
            this.contentEncoding = info.GetString("contentEncoding");
            this.contentLength = info.GetInt64("contentLength");
            this.contentType = info.GetString("contentType");
            this.cookies = (CookieCollection)info.GetValue("cookies", typeof(CookieCollection));
            this.lastModified = info.GetDateTime("lastModified");
            this.method = info.GetString("method");
            this.protocolVersion = (Version)info.GetValue("protocolVersion", typeof(Version));
            this.responseUri = (Uri)info.GetValue("responseUri", typeof(Uri));
            this.server = info.GetString("server");
            this.statusCode = (HttpStatusCode)info.GetValue("statusCode", typeof(HttpStatusCode));
            this.statusDescription = info.GetString("statusDescription");
        }


        #endregion
    }
}
