/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.view.internal;

import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanMapping;
import org.codehaus.annogen.override.AnnoBeanSet;
import org.codehaus.annogen.override.AnnoContext;
import org.codehaus.annogen.override.AnnoOverrider;
import org.codehaus.annogen.override.ElementId;
import org.codehaus.annogen.override.internal.AnnoBeanSetImpl;
import org.codehaus.annogen.override.internal.CompositeAnnoOverrider;
import org.codehaus.annogen.override.internal.ElementIdImpl;
import org.codehaus.annogen.view.internal.AnnoViewerParamsImpl;
import org.codehaus.annogen.view.internal.IndigenousAnnoExtractor;
import org.codehaus.jam.provider.JamLogger;

public abstract class AnnoViewerBase {
    private AnnoContext mContext;
    private AnnoBeanMapping mMapping;
    private AnnoOverrider mOverrider;
    protected JamLogger mLogger;

    public AnnoViewerBase(AnnoViewerParamsImpl asp) {
        if (asp == null) {
            throw new IllegalArgumentException("null asp");
        }
        AnnoOverrider[] pps = asp.getPopulators();
        this.mOverrider = pps == null || pps.length == 0 ? null : (pps.length == 1 ? pps[0] : new CompositeAnnoOverrider(pps));
        if (this.mOverrider != null) {
            this.mOverrider.init(asp);
        }
        this.mMapping = asp.getAnnoBeanMapping();
        this.mLogger = asp.getLogger();
        this.mContext = asp;
    }

    public AnnoBean[] getAnnotations(ElementId id) {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        AnnoBeanSetImpl apsi = new AnnoBeanSetImpl(this.mContext);
        this.getIndigenousAnnotations(id, apsi);
        if (this.mOverrider != null) {
            this.mOverrider.modifyAnnos(id, apsi);
        }
        return apsi.getAll();
    }

    public AnnoBean getAnnotation(Class what, ElementId where) {
        Class beanClass;
        try {
            beanClass = this.mMapping.getAnnoBeanClassForRequest(what);
        }
        catch (ClassNotFoundException cnfe) {
            this.mLogger.error(cnfe);
            return null;
        }
        AnnoBean[] annos = this.getAnnotations(where);
        for (int i = 0; i < annos.length; ++i) {
            if (!beanClass.isAssignableFrom(annos[i].getClass())) continue;
            return annos[i];
        }
        return null;
    }

    private void getIndigenousAnnotations(ElementId id, AnnoBeanSet out) {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        if (out == null) {
            throw new IllegalArgumentException("null out");
        }
        IndigenousAnnoExtractor iae = ((ElementIdImpl)id).getIAE();
        if (iae == null) {
            throw new IllegalStateException();
        }
        iae.extractIndigenousAnnotations(out);
    }
}

