/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.impl.nio.reactor.ChannelQueue;
import org.apache.http.impl.nio.reactor.IOSessionImpl;
import org.apache.http.impl.nio.reactor.SessionClosedCallback;
import org.apache.http.impl.nio.reactor.SessionQueue;
import org.apache.http.impl.nio.reactor.SessionRequestImpl;
import org.apache.http.impl.nio.reactor.SessionSet;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOSession;

public abstract class AbstractIOReactor
implements IOReactor {
    private volatile boolean closed = false;
    private final long selectTimeout;
    private final Selector selector;
    private final SessionSet sessions;
    private final SessionQueue closedSessions;
    private final ChannelQueue newChannels;
    protected IOEventDispatch eventDispatch = null;

    public AbstractIOReactor(long selectTimeout) throws IOReactorException {
        if (selectTimeout <= 0L) {
            throw new IllegalArgumentException("Select timeout may not be negative or zero");
        }
        this.selectTimeout = selectTimeout;
        this.sessions = new SessionSet();
        this.closedSessions = new SessionQueue();
        this.newChannels = new ChannelQueue();
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure opening selector", ex);
        }
    }

    protected abstract void acceptable(SelectionKey var1);

    protected abstract void connectable(SelectionKey var1);

    protected abstract void readable(SelectionKey var1);

    protected abstract void writable(SelectionKey var1);

    protected abstract void timeoutCheck(SelectionKey var1, long var2);

    protected abstract void validate(Set var1);

    protected abstract void keyCreated(SelectionKey var1, IOSession var2);

    protected abstract IOSession keyCancelled(SelectionKey var1);

    public void addChannel(ChannelEntry channelEntry) {
        if (channelEntry == null) {
            throw new IllegalArgumentException("Channel entry may not be null");
        }
        this.newChannels.push(channelEntry);
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IOEventDispatch eventDispatch) throws InterruptedIOException, IOReactorException {
        if (eventDispatch == null) {
            throw new IllegalArgumentException("Event dispatcher may not be null");
        }
        this.eventDispatch = eventDispatch;
        try {
            while (true) {
                int readyCount;
                try {
                    readyCount = this.selector.select(this.selectTimeout);
                }
                catch (InterruptedIOException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    throw new IOReactorException("Unexpected selector failure", ex);
                }
                if (this.closed) {
                    break;
                }
                this.processNewChannels();
                if (readyCount > 0) {
                    this.processEvents(this.selector.selectedKeys());
                }
                this.validate(this.selector.keys());
                this.processClosedSessions();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
        }
        finally {
            this.closeSessions();
        }
    }

    private void processEvents(Set selectedKeys) {
        Iterator it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            this.processEvent(key);
        }
        selectedKeys.clear();
    }

    private void processEvent(SelectionKey key) {
        try {
            if (key.isAcceptable()) {
                this.acceptable(key);
            }
            if (key.isConnectable()) {
                this.connectable(key);
            }
            if (key.isReadable()) {
                this.readable(key);
            }
            if (key.isWritable()) {
                this.writable(key);
            }
        }
        catch (CancelledKeyException ex) {
            IOSession session = this.keyCancelled(key);
            if (session != null) {
                this.closedSessions.push(session);
            }
            key.attach(null);
        }
    }

    private void processNewChannels() throws IOReactorException {
        ChannelEntry entry;
        while ((entry = this.newChannels.pop()) != null) {
            SelectionKey key;
            SocketChannel channel;
            try {
                channel = entry.getChannel();
                channel.configureBlocking(false);
                key = channel.register(this.selector, 0);
            }
            catch (IOException ex) {
                throw new IOReactorException("Failure registering channel with the selector", ex);
            }
            IOSessionImpl session = new IOSessionImpl(key, new SessionClosedCallback(){

                public void sessionClosed(IOSession session) {
                    AbstractIOReactor.this.closedSessions.push(session);
                }
            });
            int timeout = 0;
            try {
                timeout = channel.socket().getSoTimeout();
            }
            catch (IOException ex) {
                // empty catch block
            }
            session.setAttribute("http.session.attachment", entry.getAttachment());
            session.setSocketTimeout(timeout);
            this.sessions.add(session);
            this.keyCreated(key, session);
            try {
                this.eventDispatch.connected(session);
                SessionRequestImpl sessionRequest = entry.getSessionRequest();
                if (sessionRequest == null) continue;
                sessionRequest.completed(session);
            }
            catch (CancelledKeyException ex) {
                this.closedSessions.push(session);
                key.attach(null);
            }
        }
    }

    private void processClosedSessions() {
        IOSession session;
        while ((session = this.closedSessions.pop()) != null) {
            if (!this.sessions.remove(session)) continue;
            this.eventDispatch.disconnected(session);
        }
    }

    private void closeSessions() {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            IOSession session = (IOSession)it.next();
            if (session.isClosed()) continue;
            session.close();
            this.eventDispatch.disconnected(session);
        }
        this.sessions.clear();
    }

    public void shutdown() throws IOReactorException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.selector.close();
        }
        catch (IOException ex) {
            throw new IOReactorException("Failure closing selector", ex);
        }
    }
}

