/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ProtocolException;
import org.apache.http.impl.nio.reactor.SessionInputBuffer;
import org.apache.http.message.BufferedHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public abstract class HttpMessageParser {
    private final SessionInputBuffer buffer;
    private static final int READ_HEAD_LINE = 0;
    private static final int READ_HEADERS = 1;
    private static final int COMPLETED = 2;
    private int state;
    private boolean endOfStream;
    private HttpMessage message;
    private CharArrayBuffer lineBuf;
    private final List headerBufs;
    private int maxLineLen = -1;
    private int maxHeaderCount = -1;

    public HttpMessageParser(SessionInputBuffer buffer, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.buffer = buffer;
        this.state = 0;
        this.endOfStream = false;
        this.headerBufs = new ArrayList();
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
    }

    public void configure() {
    }

    public void reset() {
        this.state = 0;
        this.endOfStream = false;
        this.headerBufs.clear();
        this.message = null;
    }

    public int fillBuffer(ReadableByteChannel channel) throws IOException {
        int bytesRead = this.buffer.fill(channel);
        if (bytesRead == -1) {
            this.endOfStream = true;
        }
        return bytesRead;
    }

    protected abstract HttpMessage createMessage(CharArrayBuffer var1) throws HttpException;

    private void parseHeadLine() throws HttpException {
        this.message = this.createMessage(this.lineBuf);
    }

    private void parseHeader() throws IOException {
        CharArrayBuffer current = this.lineBuf;
        int count = this.headerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && count > 0) {
            char ch;
            int i;
            CharArrayBuffer previous = (CharArrayBuffer)this.headerBufs.get(count - 1);
            for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
            }
            if (this.maxLineLen > 0 && previous.length() + 1 + current.length() - i > this.maxLineLen) {
                throw new IOException("Maximum line length limit exceeded");
            }
            previous.append(' ');
            previous.append(current, i, current.length() - i);
        } else {
            this.headerBufs.add(current);
            this.lineBuf = null;
        }
    }

    public HttpMessage parse() throws IOException, HttpException {
        while (this.state != 2) {
            if (this.lineBuf == null) {
                this.lineBuf = new CharArrayBuffer(64);
            } else {
                this.lineBuf.clear();
            }
            boolean lineComplete = this.buffer.readLine(this.lineBuf, this.endOfStream);
            if (this.maxLineLen > 0 && this.lineBuf.length() > this.maxLineLen) {
                throw new IOException("Maximum line length limit exceeded");
            }
            if (!lineComplete) break;
            switch (this.state) {
                case 0: {
                    this.parseHeadLine();
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (this.lineBuf.length() > 0) {
                        if (this.maxHeaderCount > 0 && this.headerBufs.size() >= this.maxHeaderCount) {
                            throw new IOException("Maximum header count exceeded");
                        }
                        this.parseHeader();
                        break;
                    }
                    this.state = 2;
                }
            }
            if (!this.endOfStream || this.buffer.hasData()) continue;
            this.state = 2;
        }
        if (this.state == 2) {
            for (int i = 0; i < this.headerBufs.size(); ++i) {
                CharArrayBuffer buffer = (CharArrayBuffer)this.headerBufs.get(i);
                try {
                    this.message.addHeader((Header)new BufferedHeader(buffer));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new ProtocolException(ex.getMessage());
                }
            }
            return this.message;
        }
        return null;
    }
}

