/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.FileWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDL11Writer {
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    private File baseFolder = null;
    private int count;

    public WSDL11Writer(File baseFolder) {
        this.baseFolder = baseFolder;
        this.count = 0;
    }

    public void writeWSDL(AxisService axisService) {
        try {
            if (axisService != null) {
                File outputFile = FileWriter.createClassFile((File)this.baseFolder, null, (String)axisService.getName(), (String)".wsdl");
                FileOutputStream fos = new FileOutputStream(outputFile);
                axisService.printWSDL((OutputStream)fos);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("WSDL writing failed!", e);
        }
    }

    public void writeWSDL(AxisService axisService, Definition definition, Map changedMap) {
        try {
            if (axisService != null) {
                this.writeWSDL(definition, axisService.getName(), changedMap, new Stack());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("WSDL writing failed!", e);
        }
    }

    private void writeWSDL(Definition definition, String serviceName, Map changedMap, Stack stack) throws Exception {
        stack.push(definition);
        Map imports = definition.getImports();
        if (imports != null && imports.size() > 0) {
            Vector importsVector = null;
            Import wsdlImport = null;
            String wsdlName = null;
            Iterator improtsVectorIter = imports.values().iterator();
            while (improtsVectorIter.hasNext()) {
                importsVector = (Vector)improtsVectorIter.next();
                Iterator importsIter = importsVector.iterator();
                while (importsIter.hasNext()) {
                    wsdlImport = (Import)importsIter.next();
                    wsdlName = "wsdl_" + this.count++ + ".wsdl";
                    Definition innerDefinition = wsdlImport.getDefinition();
                    if (!stack.contains(innerDefinition)) {
                        this.writeWSDL(innerDefinition, wsdlName, changedMap, stack);
                    }
                    wsdlImport.setLocationURI(wsdlName);
                }
            }
        }
        this.adjustWSDLSchemaLocations(definition, changedMap);
        WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
        File outputFile = FileWriter.createClassFile((File)this.baseFolder, null, (String)serviceName, (String)".wsdl");
        FileOutputStream out = new FileOutputStream(outputFile);
        if (definition.getServices().size() > 1) {
            Service service;
            ArrayList<Service> removedServices = new ArrayList<Service>();
            ArrayList servicesList = new ArrayList();
            Map services = definition.getServices();
            Iterator iter = services.values().iterator();
            while (iter.hasNext()) {
                servicesList.add(iter.next());
            }
            Iterator iter2 = servicesList.iterator();
            while (iter2.hasNext()) {
                service = (Service)iter2.next();
                if (service.getQName().getLocalPart().equals(serviceName)) continue;
                definition.removeService(service.getQName());
                removedServices.add(service);
            }
            wsdlWriter.writeWSDL(definition, (OutputStream)out);
            iter2 = removedServices.iterator();
            while (iter2.hasNext()) {
                service = (Service)iter2.next();
                definition.addService(service);
            }
        } else {
            wsdlWriter.writeWSDL(definition, (OutputStream)out);
        }
        out.flush();
        out.close();
        stack.pop();
    }

    public void adjustWSDLSchemaLocatins(Definition definition, Map changedSchemaLocations) {
        this.adjustWSDLSchemaLocations(definition, changedSchemaLocations);
    }

    public void adjustWSDLSchemaLocations(Definition definition, Map changedSchemaLocations) {
        Types wsdlTypes = definition.getTypes();
        if (wsdlTypes != null) {
            List extensibilityElements = wsdlTypes.getExtensibilityElements();
            Iterator iter = extensibilityElements.iterator();
            while (iter.hasNext()) {
                Object currentObject = iter.next();
                if (!(currentObject instanceof Schema)) continue;
                Schema schema = (Schema)currentObject;
                this.changeLocations(schema.getElement(), changedSchemaLocations);
            }
        }
    }

    private void changeLocations(Element element, Map changedScheamLocations) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            this.processImport(nodeList.item(i), changedScheamLocations);
        }
    }

    private void processImport(Node importNode, Map changedScheamLocations) {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String attributeValue;
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals(SCHEMA_LOCATION) || changedScheamLocations.get(attributeValue = attribute.getNodeValue()) == null) continue;
            attribute.setNodeValue((String)changedScheamLocations.get(attributeValue));
        }
    }
}

