/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.wsdl20.extensions.http;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.extensions.http.HTTPLocationTemplate;

public class HTTPLocation {
    private String fOriginalLocation;
    boolean fValid = true;
    private List fValidatedList = null;
    private List fConsolidatedList = null;
    private final String emptyString = "".intern();
    private final String questionMark = "?".intern();
    private final String leftBrace = "{".intern();
    private final String rightBrace = "}".intern();
    private final String doubleLeftBraces = "{{".intern();
    private final String doubleRightBraces = "}}".intern();
    private final String exclamatedLeftBrace = "{!".intern();

    public HTTPLocation(String location) {
        this.fOriginalLocation = location;
        if (location == null) {
            this.fValid = false;
        } else if (location.equals(this.emptyString)) {
            this.fValidatedList = new Vector();
            this.fValidatedList.add(this.emptyString);
            this.fConsolidatedList = new Vector();
            this.fConsolidatedList.add(this.emptyString);
        } else {
            List tokenizedList = this.tokenizeLocation();
            this.validateTokens(tokenizedList);
            if (this.fValid) {
                this.consolidateTokens();
            }
        }
    }

    public boolean isLocationValid() {
        return this.fValid;
    }

    public String getOriginalLocation() {
        return this.fOriginalLocation;
    }

    public String getFormattedLocation() {
        if (!this.fValid) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.fConsolidatedList.iterator();
        while (it.hasNext()) {
            Object currToken = it.next();
            if (currToken instanceof HTTPLocationTemplate) {
                HTTPLocationTemplate template = (HTTPLocationTemplate)currToken;
                String value = template.getValue();
                if (value == null) continue;
                buffer.append(value);
                continue;
            }
            buffer.append(currToken);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getFormattedLocation();
    }

    public HTTPLocationTemplate[] getTemplates() {
        Vector templates = new Vector();
        if (this.fValid) {
            Iterator it = this.fConsolidatedList.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof HTTPLocationTemplate)) continue;
                templates.add(next);
            }
        }
        HTTPLocationTemplate[] array = new HTTPLocationTemplate[templates.size()];
        templates.toArray(array);
        return array;
    }

    public HTTPLocationTemplate[] getTemplatesInPath() {
        Vector templates = new Vector();
        if (this.fValid) {
            Iterator it = this.fConsolidatedList.iterator();
            while (it.hasNext()) {
                HTTPLocationTemplate template;
                Object next = it.next();
                if (!(next instanceof HTTPLocationTemplate) || (template = (HTTPLocationTemplate)next).isQuery()) continue;
                templates.add(next);
            }
        }
        HTTPLocationTemplate[] array = new HTTPLocationTemplate[templates.size()];
        templates.toArray(array);
        return array;
    }

    public HTTPLocationTemplate[] getTemplatesInQuery() {
        Vector templates = new Vector();
        if (this.fValid) {
            Iterator it = this.fConsolidatedList.iterator();
            while (it.hasNext()) {
                HTTPLocationTemplate template;
                Object next = it.next();
                if (!(next instanceof HTTPLocationTemplate) || !(template = (HTTPLocationTemplate)next).isQuery()) continue;
                templates.add(next);
            }
        }
        HTTPLocationTemplate[] array = new HTTPLocationTemplate[templates.size()];
        templates.toArray(array);
        return array;
    }

    public String[] getTemplateNames() {
        Vector<String> names = new Vector<String>();
        if (this.fValid) {
            Iterator it = this.fConsolidatedList.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof HTTPLocationTemplate)) continue;
                HTTPLocationTemplate template = (HTTPLocationTemplate)next;
                names.add(template.getName());
            }
        }
        String[] array = new String[names.size()];
        names.toArray(array);
        return array;
    }

    public String[] getTemplateNamesInPath() {
        Vector<String> names = new Vector<String>();
        if (this.fValid) {
            Iterator it = this.fConsolidatedList.iterator();
            while (it.hasNext()) {
                HTTPLocationTemplate template;
                Object next = it.next();
                if (!(next instanceof HTTPLocationTemplate) || (template = (HTTPLocationTemplate)next).isQuery()) continue;
                names.add(template.getName());
            }
        }
        String[] array = new String[names.size()];
        names.toArray(array);
        return array;
    }

    public String[] getTemplateNamesInQuery() {
        Vector<String> names = new Vector<String>();
        if (this.fValid) {
            Iterator it = this.fConsolidatedList.iterator();
            while (it.hasNext()) {
                HTTPLocationTemplate template;
                Object next = it.next();
                if (!(next instanceof HTTPLocationTemplate) || !(template = (HTTPLocationTemplate)next).isQuery()) continue;
                names.add(template.getName());
            }
        }
        String[] array = new String[names.size()];
        names.toArray(array);
        return array;
    }

    public HTTPLocationTemplate getTemplate(String name) {
        if (!this.fValid) {
            return null;
        }
        HTTPLocationTemplate namedTemplate = null;
        if (name != null) {
            HTTPLocationTemplate[] templates = this.getTemplates();
            for (int i = 0; i < templates.length; ++i) {
                if (!templates[i].getName().equals(name)) continue;
                namedTemplate = templates[i];
                break;
            }
        }
        return namedTemplate;
    }

    public HTTPLocationTemplate[] getTemplates(String name) {
        Vector<HTTPLocationTemplate> namedTemplates = new Vector<HTTPLocationTemplate>();
        if (this.fValid && name != null) {
            HTTPLocationTemplate[] templates = this.getTemplates();
            for (int i = 0; i < templates.length; ++i) {
                if (!templates[i].getName().equals(name)) continue;
                namedTemplates.add(templates[i]);
            }
        }
        HTTPLocationTemplate[] array = new HTTPLocationTemplate[namedTemplates.size()];
        namedTemplates.toArray(array);
        return array;
    }

    public HTTPLocationTemplate getTemplateInPath(String name) {
        if (!this.fValid) {
            return null;
        }
        HTTPLocationTemplate namedTemplate = null;
        if (name != null) {
            HTTPLocationTemplate[] templates = this.getTemplatesInPath();
            for (int i = 0; i < templates.length; ++i) {
                if (!templates[i].getName().equals(name)) continue;
                namedTemplate = templates[i];
                break;
            }
        }
        return namedTemplate;
    }

    public HTTPLocationTemplate[] getTemplatesInPath(String name) {
        Vector<HTTPLocationTemplate> namedTemplates = new Vector<HTTPLocationTemplate>();
        if (this.fValid && name != null) {
            HTTPLocationTemplate[] templates = this.getTemplatesInPath();
            for (int i = 0; i < templates.length; ++i) {
                if (!templates[i].getName().equals(name)) continue;
                namedTemplates.add(templates[i]);
            }
        }
        HTTPLocationTemplate[] array = new HTTPLocationTemplate[namedTemplates.size()];
        namedTemplates.toArray(array);
        return array;
    }

    public HTTPLocationTemplate getTemplateInQuery(String name) {
        if (!this.fValid) {
            return null;
        }
        HTTPLocationTemplate namedTemplate = null;
        if (name != null) {
            HTTPLocationTemplate[] templates = this.getTemplatesInQuery();
            for (int i = 0; i < templates.length; ++i) {
                if (!templates[i].getName().equals(name)) continue;
                namedTemplate = templates[i];
                break;
            }
        }
        return namedTemplate;
    }

    public HTTPLocationTemplate[] getTemplatesInQuery(String name) {
        Vector<HTTPLocationTemplate> namedTemplates = new Vector<HTTPLocationTemplate>();
        if (this.fValid && name != null) {
            HTTPLocationTemplate[] templates = this.getTemplatesInQuery();
            for (int i = 0; i < templates.length; ++i) {
                if (!templates[i].getName().equals(name)) continue;
                namedTemplates.add(templates[i]);
            }
        }
        HTTPLocationTemplate[] array = new HTTPLocationTemplate[namedTemplates.size()];
        namedTemplates.toArray(array);
        return array;
    }

    private List tokenizeLocation() {
        StringBuffer buffer = new StringBuffer();
        int len = this.fOriginalLocation.length();
        int lastPos = len - 1;
        Vector<String> tokens = new Vector<String>();
        boolean questionMarkFound = false;
        for (int i = 0; i < len; ++i) {
            char currChar = this.fOriginalLocation.charAt(i);
            if (currChar == '?' && !questionMarkFound) {
                if (buffer.length() > 0) {
                    tokens.add(buffer.toString());
                    buffer = new StringBuffer();
                }
                questionMarkFound = true;
                tokens.add(this.questionMark);
                continue;
            }
            if (currChar == '{') {
                if (buffer.length() > 0) {
                    tokens.add(buffer.toString());
                    buffer = new StringBuffer();
                }
                if (i < lastPos && this.fOriginalLocation.charAt(i + 1) == '{') {
                    tokens.add(this.doubleLeftBraces);
                    ++i;
                    continue;
                }
                if (i < lastPos && this.fOriginalLocation.charAt(i + 1) == '!') {
                    tokens.add(this.exclamatedLeftBrace);
                    ++i;
                    continue;
                }
                tokens.add(this.leftBrace);
                continue;
            }
            if (currChar == '}') {
                if (buffer.length() > 0) {
                    tokens.add(buffer.toString());
                    buffer = new StringBuffer();
                }
                if (i < lastPos && this.fOriginalLocation.charAt(i + 1) == '}') {
                    tokens.add(this.doubleRightBraces);
                    ++i;
                    continue;
                }
                tokens.add(this.rightBrace);
                continue;
            }
            buffer.append(currChar);
        }
        if (buffer.length() > 0) {
            tokens.add(buffer.toString());
        }
        return tokens;
    }

    private void validateTokens(List tokenizedList) {
        Vector<Object> tokens = new Vector<Object>();
        int size = tokenizedList.size();
        ListIterator it = tokenizedList.listIterator();
        boolean isQuery = false;
        while (this.fValid && it.hasNext()) {
            Object currToken = it.next();
            int currIndex = it.previousIndex();
            if (currToken == this.questionMark) {
                isQuery = true;
                tokens.add(this.questionMark);
                continue;
            }
            if (currToken == this.doubleLeftBraces || currToken == this.doubleRightBraces) {
                tokens.add(currToken);
                continue;
            }
            if (currToken == this.leftBrace || currToken == this.exclamatedLeftBrace) {
                if (size - currIndex < 3) {
                    this.fValid = false;
                    continue;
                }
                String nextToken = (String)it.next();
                Object nextNextToken = it.next();
                if (NCName.isValid(nextToken) && nextNextToken == this.rightBrace) {
                    boolean isEncoded = currToken == this.leftBrace;
                    HTTPLocationTemplate template = new HTTPLocationTemplate(nextToken, isEncoded, isQuery);
                    tokens.add(template);
                    continue;
                }
                this.fValid = false;
                continue;
            }
            String s = (String)currToken;
            int index = s.indexOf(this.leftBrace);
            if (index < 0) {
                index = s.indexOf(this.rightBrace);
            }
            if (index >= 0) {
                this.fValid = false;
                continue;
            }
            tokens.add(currToken);
        }
        if (this.fValid) {
            this.fValidatedList = tokens;
        }
    }

    private void consolidateTokens() {
        StringBuffer buffer = new StringBuffer();
        Vector<String> tokens = new Vector<String>();
        Iterator it = this.fValidatedList.iterator();
        while (it.hasNext()) {
            Object currToken = it.next();
            if (currToken instanceof HTTPLocationTemplate) {
                if (buffer.length() > 0) {
                    tokens.add(buffer.toString());
                    buffer = new StringBuffer();
                }
                tokens.add((String)currToken);
                continue;
            }
            if (currToken == this.doubleLeftBraces) {
                buffer.append(this.leftBrace);
                continue;
            }
            if (currToken == this.doubleRightBraces) {
                buffer.append(this.rightBrace);
                continue;
            }
            buffer.append(currToken);
        }
        if (buffer.length() > 0) {
            tokens.add(buffer.toString());
        }
        this.fConsolidatedList = tokens;
    }
}

