/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.resolver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.resolver.SchemaResolverAdapter;
import org.apache.woden.internal.schema.SchemaConstants;
import org.apache.woden.resolver.URIResolver;

public class OMSchemaResolverAdapter
extends SchemaResolverAdapter {
    public OMSchemaResolverAdapter(URIResolver actualResolver, XMLElement schemaElement) {
        super(actualResolver, schemaElement);
    }

    protected InputStream resolveFragId(String fragId) {
        String id = fragId.substring(1);
        OMElement contextEl = (OMElement)this.fContextElement.getSource();
        OMElement typesEl = (OMElement)contextEl.getParent();
        Iterator inlineSchemas = typesEl.getChildrenWithName(SchemaConstants.Q_ELEM_XSD_2001);
        OMElement identifiedSchema = null;
        while (inlineSchemas.hasNext()) {
            OMElement schema = (OMElement)inlineSchemas.next();
            String schemaId = schema.getAttributeValue(SchemaConstants.Q_ATTR_ID);
            if (schemaId == null || !schemaId.equals(id)) continue;
            identifiedSchema = schema;
            break;
        }
        if (identifiedSchema == null) {
            return null;
        }
        String schemaString = null;
        try {
            schemaString = identifiedSchema.toStringWithConsume();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        byte[] schemaBytes = schemaString.getBytes();
        ByteArrayInputStream iStream = new ByteArrayInputStream(schemaBytes);
        return iStream;
    }
}

