/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class DOMMessageFormatter {
    public static final String DOM_DOMAIN = "http://www.w3.org/dom/DOMTR";
    public static final String XML_DOMAIN = "http://www.w3.org/TR/1998/REC-xml-19980210";
    public static final String SERIALIZER_DOMAIN = "http://apache.org/xml/serializer";
    private static ResourceBundle domResourceBundle = null;
    private static ResourceBundle xmlResourceBundle = null;
    private static ResourceBundle serResourceBundle = null;
    private static Locale locale = null;
    public static final String LEVEL3_NOT_SUPPORTED = "DOM Level 3 operations are not supported";
    public static final String NOT_REQUIRED_FOR_XMLSEC_OR_WSS4J = "This method is not required by Apache XML-Security Impl or WSS4J";

    DOMMessageFormatter() {
        locale = Locale.getDefault();
    }

    public static String formatMessage(String domain, String key, Object[] arguments) throws MissingResourceException {
        String msg;
        ResourceBundle resourceBundle = DOMMessageFormatter.getResourceBundle(domain);
        if (resourceBundle == null) {
            DOMMessageFormatter.init();
            resourceBundle = DOMMessageFormatter.getResourceBundle(domain);
            if (resourceBundle == null) {
                throw new MissingResourceException("Unknown domain" + domain, null, key);
            }
        }
        try {
            msg = key + ": " + resourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg = MessageFormat.format(msg, arguments);
                }
                catch (Exception e) {
                    msg = resourceBundle.getString("FormatFailed");
                    msg = msg + " " + resourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e) {
            String msg2 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg == null) {
            msg = key;
            if (arguments.length > 0) {
                StringBuffer str = new StringBuffer(msg);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                }
            }
        }
        return msg;
    }

    static ResourceBundle getResourceBundle(String domain) {
        if (domain == DOM_DOMAIN || domain.equals(DOM_DOMAIN)) {
            return domResourceBundle;
        }
        if (domain == XML_DOMAIN || domain.equals(XML_DOMAIN)) {
            return xmlResourceBundle;
        }
        if (domain == SERIALIZER_DOMAIN || domain.equals(SERIALIZER_DOMAIN)) {
            return serResourceBundle;
        }
        return null;
    }

    public static void init() {
        if (locale != null) {
            domResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.DOMMessages", locale);
            serResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLSerializerMessages", locale);
            xmlResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLMessages", locale);
        } else {
            domResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.DOMMessages");
            serResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLSerializerMessages");
            xmlResourceBundle = PropertyResourceBundle.getBundle("org.apache.axiom.om.impl.dom.msg.XMLMessages");
        }
    }

    public static void setLocale(Locale dlocale) {
        locale = dlocale;
    }
}

