/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import javax.activation.DataHandler;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.AxisServiceGroup;

public class ClusteringUtils {
    public static void loadServiceGroup(String serviceGroupName, ConfigurationContext configCtx, String tempDirectory) throws Exception {
        File serviceArchive;
        String axis2Repo;
        if (!serviceGroupName.endsWith(".aar")) {
            serviceGroupName = serviceGroupName + ".aar";
        }
        if (ClusteringUtils.isURL(axis2Repo = System.getProperty("axis2.repo"))) {
            DataHandler dh = new DataHandler(new URL(axis2Repo + "services/" + serviceGroupName));
            String tempDir = tempDirectory + File.separator + ((double)System.currentTimeMillis() + new Random().nextDouble());
            new File(tempDir).mkdirs();
            serviceArchive = new File(tempDir + File.separator + serviceGroupName);
            FileOutputStream out = new FileOutputStream(serviceArchive);
            dh.writeTo((OutputStream)out);
            out.close();
        } else {
            serviceArchive = new File(axis2Repo + File.separator + "services" + File.separator + serviceGroupName);
        }
        AxisServiceGroup asGroup = DeploymentEngine.loadServiceGroup((File)serviceArchive, (ConfigurationContext)configCtx);
        configCtx.getAxisConfiguration().addServiceGroup(asGroup);
    }

    private static boolean isURL(String location) {
        try {
            new URL(location);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

