/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.dispatch;

import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.client.dispatch.BaseDispatch;
import org.apache.axis2.jaxws.client.dispatch.JAXBDispatchAsyncListener;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.BlockFactory;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.spi.ServiceDelegate;
import org.apache.axis2.jaxws.utility.XMLRootElementUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDispatch<T>
extends BaseDispatch<T> {
    private static final Log log = LogFactory.getLog(JAXBDispatch.class);
    private JAXBContext jaxbContext;

    public JAXBDispatch(ServiceDelegate svcDelegate, EndpointDescription epDesc) {
        super(svcDelegate, epDesc);
    }

    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public void setJAXBContext(JAXBContext jbc) {
        this.jaxbContext = jbc;
    }

    @Override
    public AsyncResponse createAsyncResponseListener() {
        JAXBDispatchAsyncListener listener = new JAXBDispatchAsyncListener(this.getEndpointDescription());
        listener.setJAXBContext(this.jaxbContext);
        listener.setMode(this.mode);
        return listener;
    }

    @Override
    public Message createMessageFromValue(Object value) {
        Message message = null;
        if (value == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Dispatch invoked with null parameter Value");
                log.debug((Object)"creating empty soap message");
            }
            try {
                return this.createEmptyMessage(Protocol.getProtocolForBinding(this.endpointDesc.getClientBindingID()));
            }
            catch (XMLStreamException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        try {
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            Class<?> clazz = value.getClass();
            JAXBBlockContext context = null;
            context = this.jaxbContext != null ? new JAXBBlockContext(this.jaxbContext) : new JAXBBlockContext(clazz.getPackage().getName());
            Protocol proto = Protocol.getProtocolForBinding(this.endpointDesc.getClientBindingID());
            QName qName = XMLRootElementUtil.getXmlRootElementQNameFromObject(value);
            Block block = factory.createFrom(value, (Object)context, qName);
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            if (this.mode.equals((Object)Service.Mode.PAYLOAD)) {
                message = mf.create(proto);
                message.setBodyBlock(block);
            } else {
                message = mf.createFrom(block, null, proto);
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return message;
    }

    @Override
    public Object getValueFromMessage(Message message) {
        return JAXBDispatch.getValue(message, this.mode, this.jaxbContext);
    }

    static Object getValue(Message message, Service.Mode mode, JAXBContext jaxbContext) {
        Object value = null;
        try {
            if (mode.equals((Object)Service.Mode.PAYLOAD)) {
                JAXBBlockContext context = new JAXBBlockContext(jaxbContext);
                JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
                Block block = message.getBodyBlock(context, factory);
                if (block != null) {
                    value = block.getBusinessObject(true);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"There are no elements in the body to unmarshal.  JAXBDispatch returns a null value");
                    }
                    value = null;
                }
            } else {
                JAXBBlockContext context = new JAXBBlockContext(jaxbContext);
                BlockFactory factory = (BlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
                value = message.getValue(context, factory);
                if (value == null && log.isDebugEnabled()) {
                    log.debug((Object)"There are no elements to unmarshal.  JAXBDispatch returns a null value");
                }
            }
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return value;
    }

    private Message createEmptyMessage(Protocol protocol) throws WebServiceException, XMLStreamException {
        MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
        Message m = mf.create(protocol);
        return m;
    }
}

