/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.HashMap;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.client.async.AsyncResult;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Utils;

public class CallbackReceiver
implements MessageReceiver {
    public static String SERVICE_NAME = "ClientService";
    private HashMap callbackStore = new HashMap();

    public void addCallback(String MsgID, Callback callback) {
        this.callbackStore.put(MsgID, callback);
    }

    public void addCallback(String msgID, AxisCallback callback) {
        this.callbackStore.put(msgID, callback);
    }

    public Object lookupCallback(String msgID) {
        return this.callbackStore.remove(msgID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageContext msgContext) throws AxisFault {
        RelatesTo relatesTO = msgContext.getOptions().getRelatesTo();
        if (relatesTO == null) {
            throw new AxisFault("Cannot identify correct Callback object. RelatesTo is null");
        }
        String messageID = relatesTO.getValue();
        Object callbackObj = this.callbackStore.remove(messageID);
        if (callbackObj == null) {
            throw new AxisFault("The Callback for MessageID " + messageID + " was not found");
        }
        if (callbackObj instanceof AxisCallback) {
            AxisCallback axisCallback = (AxisCallback)callbackObj;
            if (msgContext.isFault()) {
                axisCallback.onFault(msgContext);
            } else {
                axisCallback.onMessage(msgContext);
            }
            axisCallback.onComplete();
            return;
        }
        Callback callback = (Callback)callbackObj;
        AsyncResult result = new AsyncResult(msgContext);
        try {
            SOAPEnvelope envelope = result.getResponseEnvelope();
            OperationContext opContext = msgContext.getOperationContext();
            if (opContext != null && !opContext.isComplete()) {
                opContext.addMessageContext(msgContext);
            }
            if (envelope.getBody().hasFault()) {
                AxisFault axisFault = Utils.getInboundFaultFromMessageContext(msgContext);
                callback.onError(axisFault);
            } else {
                callback.onComplete(result);
            }
        }
        catch (Exception e) {
            callback.onError(e);
        }
        finally {
            callback.setComplete(true);
        }
    }

    public HashMap getCallbackStore() {
        return this.callbackStore;
    }
}

