/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import java.io.InputStream;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSConnectionFactory;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSMessageReceiver
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)JMSMessageReceiver.class);
    private Executor workerPool = null;
    private ConfigurationContext axisConf = null;
    private JMSConnectionFactory jmsConFac = null;

    JMSMessageReceiver(JMSConnectionFactory jmsConFac, Executor workerPool, ConfigurationContext axisConf) {
        this.jmsConFac = jmsConFac;
        this.workerPool = workerPool;
        this.axisConf = axisConf;
    }

    public ConfigurationContext getAxisConf() {
        return this.axisConf;
    }

    public void setWorkerPool(Executor workerPool) {
        this.workerPool = workerPool;
    }

    public void onMessage(Message message) {
        try {
            if (log.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("Received JMS message to destination : " + message.getJMSDestination());
                sb.append("\nMessage ID : " + message.getJMSMessageID());
                sb.append("\nCorrelation ID : " + message.getJMSCorrelationID());
                sb.append("\nReplyTo ID : " + message.getJMSReplyTo());
                log.debug((Object)sb.toString());
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        this.workerPool.execute((Runnable)new Worker(message));
    }

    private MessageContext createMessageContext(Message message) {
        InputStream in = JMSUtils.getInputStream(message);
        try {
            String soapAction;
            Parameter param;
            String provider;
            MessageContext msgContext = this.axisConf.createMessageContext();
            Destination dest = message.getJMSDestination();
            String destinationName = null;
            if (dest instanceof Queue) {
                destinationName = ((Queue)dest).getQueueName();
            } else if (dest instanceof Topic) {
                destinationName = ((Topic)dest).getTopicName();
            }
            String serviceName = this.jmsConFac.getServiceByDestination(destinationName);
            if (serviceName == null && (provider = (String)this.jmsConFac.getProperties().get("java.naming.factory.initial")).indexOf("activemq") != -1) {
                serviceName = this.jmsConFac.getServiceNameForDestination((dest instanceof Queue ? "dynamicQueues/" : "dynamicTopics/") + destinationName);
            }
            if (serviceName != null) {
                msgContext.setAxisService(this.axisConf.getAxisConfiguration().getService(serviceName));
            }
            msgContext.setIncomingTransportName("jms");
            msgContext.setTransportIn(this.axisConf.getAxisConfiguration().getTransportIn("jms"));
            msgContext.setTransportOut(this.axisConf.getAxisConfiguration().getTransportOut("jms"));
            JMSOutTransportInfo jmsOutTransportInfo = this.jmsConFac.getJndiUser() == null || this.jmsConFac.getJndiPass() == null ? new JMSOutTransportInfo(this.jmsConFac.getConFactory(), message.getJMSReplyTo()) : new JMSOutTransportInfo(this.jmsConFac.getConFactory(), this.jmsConFac.getUser(), this.jmsConFac.getPass(), message.getJMSReplyTo());
            msgContext.setProperty("OutTransportInfo", jmsOutTransportInfo);
            msgContext.setServerSide(true);
            msgContext.setMessageID(message.getJMSMessageID());
            Destination replyTo = message.getJMSReplyTo();
            String jndiDestinationName = null;
            if (replyTo == null && (param = msgContext.getAxisService().getParameter("transport.jms.ReplyDestination")) != null && param.getValue() != null) {
                jndiDestinationName = (String)param.getValue();
            }
            if (jndiDestinationName != null) {
                msgContext.setReplyTo(this.jmsConFac.getEPRForDestination(jndiDestinationName));
            }
            if ((soapAction = JMSUtils.getProperty(message, "SOAPAction")) != null) {
                msgContext.setSoapAction(soapAction);
            }
            msgContext.setEnvelope(JMSUtils.getSOAPEnvelope(message, msgContext, in));
            String correlationId = message.getJMSCorrelationID();
            if (correlationId != null && correlationId.length() > 0) {
                msgContext.setProperty("JMS_COORELATION_ID", correlationId);
                msgContext.setRelationships(new RelatesTo[]{new RelatesTo(correlationId)});
            }
            return msgContext;
        }
        catch (JMSException e) {
            this.handleException("JMS Exception reading the destination name", (Exception)((Object)e));
        }
        catch (AxisFault e) {
            this.handleException("Axis fault creating the MessageContext", e);
        }
        catch (XMLStreamException e) {
            this.handleException("Error reading the SOAP envelope", e);
        }
        return null;
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    class Worker
    implements Runnable {
        private Message message = null;

        Worker(Message message) {
            this.message = message;
        }

        public void run() {
            MessageContext msgCtx = JMSMessageReceiver.this.createMessageContext(this.message);
            AxisEngine engine = new AxisEngine(msgCtx.getConfigurationContext());
            try {
                log.debug((Object)"Delegating JMS message for processing to the Axis engine");
                try {
                    AxisEngine.receive(msgCtx);
                }
                catch (AxisFault e) {
                    log.debug((Object)"Exception occured when receiving the SOAP message", (Throwable)e);
                    if (msgCtx.isServerSide()) {
                        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgCtx, e);
                        AxisEngine.sendFault(faultContext);
                    }
                }
            }
            catch (AxisFault af) {
                log.error((Object)("JMS Worker [" + Thread.currentThread().getName() + "] Encountered an Axis Fault : " + af.getMessage()), (Throwable)af);
            }
        }
    }
}

