/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "config.h"
#include "V8TestObj.h"

#include "ExceptionCode.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptCallStack.h"
#include "SerializedScriptValue.h"
#include "V8Binding.h"
#include "V8BindingState.h"
#include "V8DOMWrapper.h"
#include "V8IsolatedContext.h"
#include "V8Proxy.h"
#include "V8log.h"
#include <wtf/GetPtr.h>
#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>

namespace WebCore {

WrapperTypeInfo V8TestObj::info = { V8TestObj::GetTemplate, V8TestObj::derefObject, 0 };

namespace TestObjInternal {

template <typename T> void V8_USE(T) { }

static v8::Handle<v8::Value> readOnlyIntAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyIntAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->readOnlyIntAttr());
}

static v8::Handle<v8::Value> readOnlyStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->readOnlyStringAttr());
}

static v8::Handle<v8::Value> readOnlyTestObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.readOnlyTestObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    RefPtr<TestObj> result = imp->readOnlyTestObjAttr();
    v8::Handle<v8::Value> wrapper = result.get() ? getDOMObjectMap().get(result.get()) : v8::Handle<v8::Value>();
    if (wrapper.IsEmpty()) {
        wrapper = toV8(result.get());
        if (!wrapper.IsEmpty())
            V8DOMWrapper::setHiddenReference(info.Holder(), wrapper);
    }
    return wrapper;
}

static v8::Handle<v8::Value> intAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.intAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->intAttr());
}

static void intAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.intAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setIntAttr(v);
    return;
}

static v8::Handle<v8::Value> longLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->longLongAttr()));
}

static void longLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.longLongAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    long long v = toInt64(value);
    imp->setLongLongAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> unsignedLongLongAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedLongLongAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Number::New(static_cast<double>(imp->unsignedLongLongAttr()));
}

static void unsignedLongLongAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.unsignedLongLongAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    unsigned long long v = toInt64(value);
    imp->setUnsignedLongLongAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> stringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8String(imp->stringAttr());
}

static void stringAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.stringAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    V8Parameter<> v = value;
    imp->setStringAttr(v);
    return;
}

static v8::Handle<v8::Value> testObjAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.testObjAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return toV8(imp->testObjAttr());
}

static void testObjAttrAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.testObjAttr._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    TestObj* v = V8TestObj::HasInstance(value) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(value)) : 0;
    imp->setTestObjAttr(WTF::getPtr(v));
    return;
}

static v8::Handle<v8::Value> attrWithExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->attrWithException());
}

static void attrWithExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    imp->setAttrWithException(v);
    return;
}

static v8::Handle<v8::Value> attrWithSetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithSetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    ExceptionCode ec = 0;
    int v = imp->attrWithSetterException(ec);
    if (UNLIKELY(ec)) {
        V8Proxy::setDOMException(ec);
        return v8::Handle<v8::Value>();
    }
    return v8::Integer::New(v);
}

static void attrWithSetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithSetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ExceptionCode ec = 0;
    imp->setAttrWithSetterException(v, ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> attrWithGetterExceptionAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithGetterException._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8::Integer::New(imp->attrWithGetterException());
}

static void attrWithGetterExceptionAttrSetter(v8::Local<v8::String> name, v8::Local<v8::Value> value, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.attrWithGetterException._set");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    int v = toInt32(value);
    ExceptionCode ec = 0;
    imp->setAttrWithGetterException(v, ec);
    if (UNLIKELY(ec))
        V8Proxy::setDOMException(ec);
    return;
}

static v8::Handle<v8::Value> scriptStringAttrAttrGetter(v8::Local<v8::String> name, const v8::AccessorInfo& info)
{
    INC_STATS("DOM.TestObj.scriptStringAttr._get");
    TestObj* imp = V8TestObj::toNative(info.Holder());
    return v8StringOrNull(imp->scriptStringAttr());
}

static v8::Handle<v8::Value> voidMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.voidMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    imp->voidMethod();
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> voidMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.voidMethodWithArgs");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    V8Parameter<> strArg = args[1];
    TestObj* objArg = V8TestObj::HasInstance(args[2]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[2])) : 0;
    imp->voidMethodWithArgs(intArg, strArg, objArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> intMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.intMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return v8::Integer::New(imp->intMethod());
}

static v8::Handle<v8::Value> intMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.intMethodWithArgs");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    V8Parameter<> strArg = args[1];
    TestObj* objArg = V8TestObj::HasInstance(args[2]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[2])) : 0;
    return v8::Integer::New(imp->intMethodWithArgs(intArg, strArg, objArg));
}

static v8::Handle<v8::Value> objMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.objMethod");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    return toV8(imp->objMethod());
}

static v8::Handle<v8::Value> objMethodWithArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.objMethodWithArgs");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    V8Parameter<> strArg = args[1];
    TestObj* objArg = V8TestObj::HasInstance(args[2]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[2])) : 0;
    return toV8(imp->objMethodWithArgs(intArg, strArg, objArg));
}

static v8::Handle<v8::Value> methodThatRequiresAllArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodThatRequiresAllArgs");
    if (args.Length() < 2)
        return v8::Handle<v8::Value>();
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8Parameter<> strArg = args[0];
    TestObj* objArg = V8TestObj::HasInstance(args[1]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[1])) : 0;
    return toV8(imp->methodThatRequiresAllArgs(strArg, objArg));
}

static v8::Handle<v8::Value> methodThatRequiresAllArgsAndThrowsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodThatRequiresAllArgsAndThrows");
    if (args.Length() < 2)
        return throwError("Not enough arguments", V8Proxy::SyntaxError);
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    V8Parameter<> strArg = args[0];
    TestObj* objArg = V8TestObj::HasInstance(args[1]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[1])) : 0;
    RefPtr<TestObj> result = imp->methodThatRequiresAllArgsAndThrows(strArg, objArg, ec);
    if (UNLIKELY(ec))
        goto fail;
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> serializedValueCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.serializedValue");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    bool serializedArgDidThrow = false;
    RefPtr<SerializedScriptValue> serializedArg = SerializedScriptValue::create(args[0], serializedArgDidThrow);
    if (serializedArgDidThrow)
        return v8::Undefined();
    imp->serializedValue(serializedArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    imp->methodWithException(ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8::Handle<v8::Value>();
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> customArgsAndExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.customArgsAndException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    OwnPtr<ScriptCallStack> callStack(ScriptCallStack::create(args, 1));
    if (!callStack)
        return v8::Undefined();
    log* intArg = V8log::HasInstance(args[0]) ? V8log::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0;
    imp->customArgsAndException(intArg, callStack.get(), ec);
    if (UNLIKELY(ec))
        goto fail;
    return v8::Handle<v8::Value>();
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> addEventListenerCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.addEventListener()");
    RefPtr<EventListener> listener = V8DOMWrapper::getEventListener(args[1], false, ListenerFindOrCreate);
    if (listener) {
        V8TestObj::toNative(args.Holder())->addEventListener(v8ValueToAtomicWebCoreString(args[0]), listener, args[2]->BooleanValue());
        createHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex);
    }
    return v8::Undefined();
}

static v8::Handle<v8::Value> removeEventListenerCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.removeEventListener()");
    RefPtr<EventListener> listener = V8DOMWrapper::getEventListener(args[1], false, ListenerFindOnly);
    if (listener) {
        V8TestObj::toNative(args.Holder())->removeEventListener(v8ValueToAtomicWebCoreString(args[0]), listener.get(), args[2]->BooleanValue());
        removeHiddenDependency(args.Holder(), args[1], V8TestObj::eventListenerCacheIndex);
    }
    return v8::Undefined();
}

static v8::Handle<v8::Value> withDynamicFrameCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withDynamicFrame");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
    if (!enteredFrame)
        return v8::Undefined();
    imp->withDynamicFrame(enteredFrame);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withDynamicFrameAndArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withDynamicFrameAndArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
    if (!enteredFrame)
        return v8::Undefined();
    imp->withDynamicFrameAndArg(enteredFrame, intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withDynamicFrameAndOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withDynamicFrameAndOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    if (args.Length() <= 1) {
        Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
        if (!enteredFrame)
            return v8::Undefined();
        imp->withDynamicFrameAndOptionalArg(enteredFrame, intArg);
        return v8::Handle<v8::Value>();
    }
    int optionalArg = toInt32(args[1]);
    Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
    if (!enteredFrame)
        return v8::Undefined();
    imp->withDynamicFrameAndOptionalArg(enteredFrame, intArg, optionalArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withDynamicFrameAndUserGestureCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withDynamicFrameAndUserGesture");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
    if (!enteredFrame)
        return v8::Undefined();
    imp->withDynamicFrameAndUserGesture(enteredFrame, intArg, processingUserGesture());
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withDynamicFrameAndUserGestureASADCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withDynamicFrameAndUserGestureASAD");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    if (args.Length() <= 1) {
        Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
        if (!enteredFrame)
            return v8::Undefined();
        imp->withDynamicFrameAndUserGestureASAD(enteredFrame, intArg, processingUserGesture());
        return v8::Handle<v8::Value>();
    }
    int optionalArg = toInt32(args[1]);
    Frame* enteredFrame = V8Proxy::retrieveFrameForEnteredContext();
    if (!enteredFrame)
        return v8::Undefined();
    imp->withDynamicFrameAndUserGestureASAD(enteredFrame, intArg, optionalArg, processingUserGesture());
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptStateVoidCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateVoid");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EmptyScriptState state;
    imp->withScriptStateVoid(&state);
    if (state.hadException())
        return throwError(state.exception());
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptStateObjCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateObj");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    EmptyScriptState state;
    RefPtr<TestObj> result = imp->withScriptStateObj(&state);
    if (state.hadException())
        return throwError(state.exception());
    return toV8(result.release());
}

static v8::Handle<v8::Value> withScriptStateVoidExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateVoidException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    EmptyScriptState state;
    imp->withScriptStateVoidException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException())
        return throwError(state.exception());
    return v8::Handle<v8::Value>();
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptStateObjExceptionCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptStateObjException");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ExceptionCode ec = 0;
    {
    EmptyScriptState state;
    RefPtr<TestObj> result = imp->withScriptStateObjException(&state, ec);
    if (UNLIKELY(ec))
        goto fail;
    if (state.hadException())
        return throwError(state.exception());
    return toV8(result.release());
    }
    fail:
    V8Proxy::setDOMException(ec);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> withScriptExecutionContextCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.withScriptExecutionContext");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    ScriptExecutionContext* scriptContext = getScriptExecutionContext();
    if (!scriptContext)
        return v8::Undefined();
    imp->withScriptExecutionContext(scriptContext);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    if (args.Length() <= 0) {
        imp->methodWithOptionalArg();
        return v8::Handle<v8::Value>();
    }
    int opt = toInt32(args[0]);
    imp->methodWithOptionalArg(opt);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndOptionalArgCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonOptionalArgAndOptionalArg");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int nonOpt = toInt32(args[0]);
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndOptionalArg(nonOpt);
        return v8::Handle<v8::Value>();
    }
    int opt = toInt32(args[1]);
    imp->methodWithNonOptionalArgAndOptionalArg(nonOpt, opt);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> methodWithNonOptionalArgAndTwoOptionalArgsCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.methodWithNonOptionalArgAndTwoOptionalArgs");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int nonOpt = toInt32(args[0]);
    if (args.Length() <= 1) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt);
        return v8::Handle<v8::Value>();
    }
    int opt1 = toInt32(args[1]);
    int opt2 = toInt32(args[2]);
    imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1, opt2);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod1Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod1");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    TestObj* objArg = V8TestObj::HasInstance(args[0]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0;
    V8Parameter<> strArg = args[1];
    imp->overloadedMethod(objArg, strArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod2Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod2");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    TestObj* objArg = V8TestObj::HasInstance(args[0]) ? V8TestObj::toNative(v8::Handle<v8::Object>::Cast(args[0])) : 0;
    if (args.Length() <= 1) {
        imp->overloadedMethod(objArg);
        return v8::Handle<v8::Value>();
    }
    int intArg = toInt32(args[1]);
    imp->overloadedMethod(objArg, intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod3Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod3");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    V8Parameter<> strArg = args[0];
    imp->overloadedMethod(strArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethod4Callback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod4");
    TestObj* imp = V8TestObj::toNative(args.Holder());
    int intArg = toInt32(args[0]);
    imp->overloadedMethod(intArg);
    return v8::Handle<v8::Value>();
}

static v8::Handle<v8::Value> overloadedMethodCallback(const v8::Arguments& args)
{
    INC_STATS("DOM.TestObj.overloadedMethod");
    if ((args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0])) && (args[1]->IsNull() || args[1]->IsUndefined() || args[1]->IsString() || args[1]->IsObject())))
        return overloadedMethod1Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0]))) || (args.Length() == 2 && (args[0]->IsNull() || V8TestObj::HasInstance(args[0]))))
        return overloadedMethod2Callback(args);
    if ((args.Length() == 1 && (args[0]->IsNull() || args[0]->IsUndefined() || args[0]->IsString() || args[0]->IsObject())))
        return overloadedMethod3Callback(args);
    if (args.Length() == 1)
        return overloadedMethod4Callback(args);
    V8Proxy::setDOMException(SYNTAX_ERR);
    return notHandledByInterceptor();
}

} // namespace TestObjInternal

static const BatchedAttribute TestObjAttrs[] = {
    // Attribute 'readOnlyIntAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyIntAttr", TestObjInternal::readOnlyIntAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyStringAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyStringAttr", TestObjInternal::readOnlyStringAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'readOnlyTestObjAttr' (Type: 'readonly attribute' ExtAttr: '')
    {"readOnlyTestObjAttr", TestObjInternal::readOnlyTestObjAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'intAttr' (Type: 'attribute' ExtAttr: '')
    {"intAttr", TestObjInternal::intAttrAttrGetter, TestObjInternal::intAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'longLongAttr' (Type: 'attribute' ExtAttr: '')
    {"longLongAttr", TestObjInternal::longLongAttrAttrGetter, TestObjInternal::longLongAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'unsignedLongLongAttr' (Type: 'attribute' ExtAttr: '')
    {"unsignedLongLongAttr", TestObjInternal::unsignedLongLongAttrAttrGetter, TestObjInternal::unsignedLongLongAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'stringAttr' (Type: 'attribute' ExtAttr: '')
    {"stringAttr", TestObjInternal::stringAttrAttrGetter, TestObjInternal::stringAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'testObjAttr' (Type: 'attribute' ExtAttr: '')
    {"testObjAttr", TestObjInternal::testObjAttrAttrGetter, TestObjInternal::testObjAttrAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithException' (Type: 'attribute' ExtAttr: '')
    {"attrWithException", TestObjInternal::attrWithExceptionAttrGetter, TestObjInternal::attrWithExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithSetterException' (Type: 'attribute' ExtAttr: '')
    {"attrWithSetterException", TestObjInternal::attrWithSetterExceptionAttrGetter, TestObjInternal::attrWithSetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'attrWithGetterException' (Type: 'attribute' ExtAttr: '')
    {"attrWithGetterException", TestObjInternal::attrWithGetterExceptionAttrGetter, TestObjInternal::attrWithGetterExceptionAttrSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'customAttr' (Type: 'attribute' ExtAttr: 'Custom')
    {"customAttr", V8TestObj::customAttrAccessorGetter, V8TestObj::customAttrAccessorSetter, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
    // Attribute 'scriptStringAttr' (Type: 'readonly attribute' ExtAttr: 'ConvertScriptString')
    {"scriptStringAttr", TestObjInternal::scriptStringAttrAttrGetter, 0, 0 /* no data */, static_cast<v8::AccessControl>(v8::DEFAULT), static_cast<v8::PropertyAttribute>(v8::None), 0 /* on instance */},
};
static const BatchedCallback TestObjCallbacks[] = {
    {"voidMethod", TestObjInternal::voidMethodCallback},
    {"intMethod", TestObjInternal::intMethodCallback},
    {"objMethod", TestObjInternal::objMethodCallback},
    {"serializedValue", TestObjInternal::serializedValueCallback},
    {"methodWithException", TestObjInternal::methodWithExceptionCallback},
    {"customMethod", V8TestObj::customMethodCallback},
    {"customMethodWithArgs", V8TestObj::customMethodWithArgsCallback},
    {"addEventListener", TestObjInternal::addEventListenerCallback},
    {"removeEventListener", TestObjInternal::removeEventListenerCallback},
    {"withDynamicFrame", TestObjInternal::withDynamicFrameCallback},
    {"withDynamicFrameAndArg", TestObjInternal::withDynamicFrameAndArgCallback},
    {"withDynamicFrameAndOptionalArg", TestObjInternal::withDynamicFrameAndOptionalArgCallback},
    {"withDynamicFrameAndUserGesture", TestObjInternal::withDynamicFrameAndUserGestureCallback},
    {"withDynamicFrameAndUserGestureASAD", TestObjInternal::withDynamicFrameAndUserGestureASADCallback},
    {"withScriptStateVoid", TestObjInternal::withScriptStateVoidCallback},
    {"withScriptStateObj", TestObjInternal::withScriptStateObjCallback},
    {"withScriptStateVoidException", TestObjInternal::withScriptStateVoidExceptionCallback},
    {"withScriptStateObjException", TestObjInternal::withScriptStateObjExceptionCallback},
    {"withScriptExecutionContext", TestObjInternal::withScriptExecutionContextCallback},
    {"methodWithOptionalArg", TestObjInternal::methodWithOptionalArgCallback},
    {"methodWithNonOptionalArgAndOptionalArg", TestObjInternal::methodWithNonOptionalArgAndOptionalArgCallback},
    {"methodWithNonOptionalArgAndTwoOptionalArgs", TestObjInternal::methodWithNonOptionalArgAndTwoOptionalArgsCallback},
    {"overloadedMethod", TestObjInternal::overloadedMethodCallback},
};
static v8::Persistent<v8::FunctionTemplate> ConfigureV8TestObjTemplate(v8::Persistent<v8::FunctionTemplate> desc)
{
    v8::Local<v8::Signature> defaultSignature = configureTemplate(desc, "TestObj", v8::Persistent<v8::FunctionTemplate>(), V8TestObj::internalFieldCount,
        TestObjAttrs, sizeof(TestObjAttrs) / sizeof(*TestObjAttrs),
        TestObjCallbacks, sizeof(TestObjCallbacks) / sizeof(*TestObjCallbacks));
    v8::Local<v8::ObjectTemplate> instance = desc->InstanceTemplate();
    v8::Local<v8::ObjectTemplate> proto = desc->PrototypeTemplate();
    

    // Custom Signature 'voidMethodWithArgs'
    const int voidMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> voidMethodWithArgsArgv[voidMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> voidMethodWithArgsSignature = v8::Signature::New(desc, voidMethodWithArgsArgc, voidMethodWithArgsArgv);
    proto->Set(v8::String::New("voidMethodWithArgs"), v8::FunctionTemplate::New(TestObjInternal::voidMethodWithArgsCallback, v8::Handle<v8::Value>(), voidMethodWithArgsSignature));

    // Custom Signature 'intMethodWithArgs'
    const int intMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> intMethodWithArgsArgv[intMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> intMethodWithArgsSignature = v8::Signature::New(desc, intMethodWithArgsArgc, intMethodWithArgsArgv);
    proto->Set(v8::String::New("intMethodWithArgs"), v8::FunctionTemplate::New(TestObjInternal::intMethodWithArgsCallback, v8::Handle<v8::Value>(), intMethodWithArgsSignature));

    // Custom Signature 'objMethodWithArgs'
    const int objMethodWithArgsArgc = 3;
    v8::Handle<v8::FunctionTemplate> objMethodWithArgsArgv[objMethodWithArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> objMethodWithArgsSignature = v8::Signature::New(desc, objMethodWithArgsArgc, objMethodWithArgsArgv);
    proto->Set(v8::String::New("objMethodWithArgs"), v8::FunctionTemplate::New(TestObjInternal::objMethodWithArgsCallback, v8::Handle<v8::Value>(), objMethodWithArgsSignature));

    // Custom Signature 'methodThatRequiresAllArgs'
    const int methodThatRequiresAllArgsArgc = 2;
    v8::Handle<v8::FunctionTemplate> methodThatRequiresAllArgsArgv[methodThatRequiresAllArgsArgc] = { v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> methodThatRequiresAllArgsSignature = v8::Signature::New(desc, methodThatRequiresAllArgsArgc, methodThatRequiresAllArgsArgv);
    proto->Set(v8::String::New("methodThatRequiresAllArgs"), v8::FunctionTemplate::New(TestObjInternal::methodThatRequiresAllArgsCallback, v8::Handle<v8::Value>(), methodThatRequiresAllArgsSignature));

    // Custom Signature 'methodThatRequiresAllArgsAndThrows'
    const int methodThatRequiresAllArgsAndThrowsArgc = 2;
    v8::Handle<v8::FunctionTemplate> methodThatRequiresAllArgsAndThrowsArgv[methodThatRequiresAllArgsAndThrowsArgc] = { v8::Handle<v8::FunctionTemplate>(), V8TestObj::GetRawTemplate() };
    v8::Handle<v8::Signature> methodThatRequiresAllArgsAndThrowsSignature = v8::Signature::New(desc, methodThatRequiresAllArgsAndThrowsArgc, methodThatRequiresAllArgsAndThrowsArgv);
    proto->Set(v8::String::New("methodThatRequiresAllArgsAndThrows"), v8::FunctionTemplate::New(TestObjInternal::methodThatRequiresAllArgsAndThrowsCallback, v8::Handle<v8::Value>(), methodThatRequiresAllArgsAndThrowsSignature));

    // Custom Signature 'customArgsAndException'
    const int customArgsAndExceptionArgc = 1;
    v8::Handle<v8::FunctionTemplate> customArgsAndExceptionArgv[customArgsAndExceptionArgc] = { V8log::GetRawTemplate() };
    v8::Handle<v8::Signature> customArgsAndExceptionSignature = v8::Signature::New(desc, customArgsAndExceptionArgc, customArgsAndExceptionArgv);
    proto->Set(v8::String::New("customArgsAndException"), v8::FunctionTemplate::New(TestObjInternal::customArgsAndExceptionCallback, v8::Handle<v8::Value>(), customArgsAndExceptionSignature));

    // Custom toString template
    desc->Set(getToStringName(), getToStringTemplate());
    return desc;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetRawTemplate()
{
    static v8::Persistent<v8::FunctionTemplate> V8TestObjRawCache = createRawTemplate();
    return V8TestObjRawCache;
}

v8::Persistent<v8::FunctionTemplate> V8TestObj::GetTemplate()
{
    static v8::Persistent<v8::FunctionTemplate> V8TestObjCache = ConfigureV8TestObjTemplate(GetRawTemplate());
    return V8TestObjCache;
}

TestObj* V8TestObj::toNative(v8::Handle<v8::Object> object)
{
    return reinterpret_cast<TestObj*>(object->GetPointerFromInternalField(v8DOMWrapperObjectIndex));
}

bool V8TestObj::HasInstance(v8::Handle<v8::Value> value)
{
    return GetRawTemplate()->HasInstance(value);
}


v8::Handle<v8::Object> V8TestObj::wrap(TestObj* impl)
{
    v8::Handle<v8::Object> wrapper;
    V8Proxy* proxy = 0;
        wrapper = getDOMObjectMap().get(impl);
        if (!wrapper.IsEmpty())
            return wrapper;
    wrapper = V8DOMWrapper::instantiateV8Object(proxy, &info, impl);
    if (wrapper.IsEmpty())
        return wrapper;

    impl->ref();
    getDOMObjectMap().set(impl, v8::Persistent<v8::Object>::New(wrapper));
    return wrapper;
}

v8::Handle<v8::Value> toV8(PassRefPtr<TestObj > impl)
{
    return toV8(impl.get());
}

v8::Handle<v8::Value> toV8(TestObj* impl)
{
    if (!impl)
        return v8::Null();
    return V8TestObj::wrap(impl);
}

void V8TestObj::derefObject(void* object)
{
    static_cast<TestObj*>(object)->deref();
}

} // namespace WebCore
