/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTestObj.h"

#include "JSEventListener.h"
#include "JSTestObj.h"
#include "JSlog.h"
#include "KURL.h"
#include "ScriptCallStack.h"
#include "SerializedScriptValue.h"
#include "TestObj.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTestObj);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTestObjTableValues[15] =
{
    { "readOnlyIntAttr", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjReadOnlyIntAttr), (intptr_t)0 THUNK_GENERATOR(0) },
    { "readOnlyStringAttr", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjReadOnlyStringAttr), (intptr_t)0 THUNK_GENERATOR(0) },
    { "readOnlyTestObjAttr", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjReadOnlyTestObjAttr), (intptr_t)0 THUNK_GENERATOR(0) },
    { "intAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjIntAttr), (intptr_t)setJSTestObjIntAttr THUNK_GENERATOR(0) },
    { "longLongAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjLongLongAttr), (intptr_t)setJSTestObjLongLongAttr THUNK_GENERATOR(0) },
    { "unsignedLongLongAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjUnsignedLongLongAttr), (intptr_t)setJSTestObjUnsignedLongLongAttr THUNK_GENERATOR(0) },
    { "stringAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjStringAttr), (intptr_t)setJSTestObjStringAttr THUNK_GENERATOR(0) },
    { "testObjAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjTestObjAttr), (intptr_t)setJSTestObjTestObjAttr THUNK_GENERATOR(0) },
    { "attrWithException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjAttrWithException), (intptr_t)setJSTestObjAttrWithException THUNK_GENERATOR(0) },
    { "attrWithSetterException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjAttrWithSetterException), (intptr_t)setJSTestObjAttrWithSetterException THUNK_GENERATOR(0) },
    { "attrWithGetterException", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjAttrWithGetterException), (intptr_t)setJSTestObjAttrWithGetterException THUNK_GENERATOR(0) },
    { "customAttr", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjCustomAttr), (intptr_t)setJSTestObjCustomAttr THUNK_GENERATOR(0) },
    { "scriptStringAttr", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjScriptStringAttr), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestObjConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTestObjTable = { 34, 31, JSTestObjTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTestObjConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTestObjConstructorTable = { 1, 0, JSTestObjConstructorTableValues, 0 };
class JSTestObjConstructor : public DOMConstructorObject {
public:
    JSTestObjConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSTestObjConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSTestObjPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSTestObjConstructor::s_info = { "TestObjConstructor", 0, &JSTestObjConstructorTable, 0 };

bool JSTestObjConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTestObjConstructor, DOMObject>(exec, &JSTestObjConstructorTable, this, propertyName, slot);
}

bool JSTestObjConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTestObjConstructor, DOMObject>(exec, &JSTestObjConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSTestObjPrototypeTableValues[30] =
{
    { "voidMethod", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionVoidMethod), (intptr_t)0 THUNK_GENERATOR(0) },
    { "voidMethodWithArgs", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionVoidMethodWithArgs), (intptr_t)3 THUNK_GENERATOR(0) },
    { "intMethod", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionIntMethod), (intptr_t)0 THUNK_GENERATOR(0) },
    { "intMethodWithArgs", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionIntMethodWithArgs), (intptr_t)3 THUNK_GENERATOR(0) },
    { "objMethod", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionObjMethod), (intptr_t)0 THUNK_GENERATOR(0) },
    { "objMethodWithArgs", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionObjMethodWithArgs), (intptr_t)3 THUNK_GENERATOR(0) },
    { "methodThatRequiresAllArgs", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionMethodThatRequiresAllArgs), (intptr_t)2 THUNK_GENERATOR(0) },
    { "methodThatRequiresAllArgsAndThrows", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionMethodThatRequiresAllArgsAndThrows), (intptr_t)2 THUNK_GENERATOR(0) },
    { "serializedValue", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionSerializedValue), (intptr_t)1 THUNK_GENERATOR(0) },
    { "methodWithException", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionMethodWithException), (intptr_t)0 THUNK_GENERATOR(0) },
    { "customMethod", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionCustomMethod), (intptr_t)0 THUNK_GENERATOR(0) },
    { "customMethodWithArgs", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionCustomMethodWithArgs), (intptr_t)3 THUNK_GENERATOR(0) },
    { "customArgsAndException", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionCustomArgsAndException), (intptr_t)1 THUNK_GENERATOR(0) },
    { "addEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionAddEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "removeEventListener", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionRemoveEventListener), (intptr_t)3 THUNK_GENERATOR(0) },
    { "withDynamicFrame", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithDynamicFrame), (intptr_t)0 THUNK_GENERATOR(0) },
    { "withDynamicFrameAndArg", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithDynamicFrameAndArg), (intptr_t)1 THUNK_GENERATOR(0) },
    { "withDynamicFrameAndOptionalArg", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithDynamicFrameAndOptionalArg), (intptr_t)2 THUNK_GENERATOR(0) },
    { "withDynamicFrameAndUserGesture", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithDynamicFrameAndUserGesture), (intptr_t)1 THUNK_GENERATOR(0) },
    { "withDynamicFrameAndUserGestureASAD", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithDynamicFrameAndUserGestureASAD), (intptr_t)2 THUNK_GENERATOR(0) },
    { "withScriptStateVoid", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithScriptStateVoid), (intptr_t)0 THUNK_GENERATOR(0) },
    { "withScriptStateObj", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithScriptStateObj), (intptr_t)0 THUNK_GENERATOR(0) },
    { "withScriptStateVoidException", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithScriptStateVoidException), (intptr_t)0 THUNK_GENERATOR(0) },
    { "withScriptStateObjException", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithScriptStateObjException), (intptr_t)0 THUNK_GENERATOR(0) },
    { "withScriptExecutionContext", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionWithScriptExecutionContext), (intptr_t)0 THUNK_GENERATOR(0) },
    { "methodWithOptionalArg", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionMethodWithOptionalArg), (intptr_t)1 THUNK_GENERATOR(0) },
    { "methodWithNonOptionalArgAndOptionalArg", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionMethodWithNonOptionalArgAndOptionalArg), (intptr_t)2 THUNK_GENERATOR(0) },
    { "methodWithNonOptionalArgAndTwoOptionalArgs", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionMethodWithNonOptionalArgAndTwoOptionalArgs), (intptr_t)3 THUNK_GENERATOR(0) },
    { "overloadedMethod", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsTestObjPrototypeFunctionOverloadedMethod), (intptr_t)2 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSTestObjPrototypeTable = { 69, 63, JSTestObjPrototypeTableValues, 0 };
const ClassInfo JSTestObjPrototype::s_info = { "TestObjPrototype", 0, &JSTestObjPrototypeTable, 0 };

JSObject* JSTestObjPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTestObj>(exec, globalObject);
}

bool JSTestObjPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTestObjPrototypeTable, this, propertyName, slot);
}

bool JSTestObjPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTestObjPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSTestObj::s_info = { "TestObj", 0, &JSTestObjTable, 0 };

JSTestObj::JSTestObj(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<TestObj> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSTestObj::~JSTestObj()
{
    forgetDOMObject(this, impl());
}

JSObject* JSTestObj::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSTestObjPrototype(globalObject, JSTestObjPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSTestObj::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTestObj, Base>(exec, &JSTestObjTable, this, propertyName, slot);
}

bool JSTestObj::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTestObj, Base>(exec, &JSTestObjTable, this, propertyName, descriptor);
}

JSValue jsTestObjReadOnlyIntAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->readOnlyIntAttr());
    return result;
}

JSValue jsTestObjReadOnlyStringAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsString(exec, imp->readOnlyStringAttr());
    return result;
}

JSValue jsTestObjReadOnlyTestObjAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->readOnlyTestObjAttr()));
    return result;
}

JSValue jsTestObjIntAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->intAttr());
    return result;
}

JSValue jsTestObjLongLongAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->longLongAttr());
    return result;
}

JSValue jsTestObjUnsignedLongLongAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->unsignedLongLongAttr());
    return result;
}

JSValue jsTestObjStringAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsString(exec, imp->stringAttr());
    return result;
}

JSValue jsTestObjTestObjAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->testObjAttr()));
    return result;
}

JSValue jsTestObjAttrWithException(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->attrWithException());
    return result;
}

JSValue jsTestObjAttrWithSetterException(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    ExceptionCode ec = 0;
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSC::JSValue result = jsNumber(exec, imp->attrWithSetterException(ec));
    setDOMException(exec, ec);
    return result;
}

JSValue jsTestObjAttrWithGetterException(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->attrWithGetterException());
    return result;
}

JSValue jsTestObjCustomAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    return castedThis->customAttr(exec);
}

JSValue jsTestObjScriptStringAttr(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue result = jsOwnedStringOrNull(exec, imp->scriptStringAttr());
    return result;
}

JSValue jsTestObjConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSTestObj* domObject = static_cast<JSTestObj*>(asObject(slotBase));
    return JSTestObj::getConstructor(exec, domObject->globalObject());
}
void JSTestObj::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSTestObj, Base>(exec, propertyName, value, &JSTestObjTable, this, slot);
}

void setJSTestObjIntAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    imp->setIntAttr(value.toInt32(exec));
}

void setJSTestObjLongLongAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    imp->setLongLongAttr(static_cast<long long>(value.toInteger(exec)));
}

void setJSTestObjUnsignedLongLongAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    imp->setUnsignedLongLongAttr(static_cast<unsigned long long>(value.toInteger(exec)));
}

void setJSTestObjStringAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    imp->setStringAttr(ustringToString(value.toString(exec)));
}

void setJSTestObjTestObjAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    imp->setTestObjAttr(toTestObj(value));
}

void setJSTestObjAttrWithException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    imp->setAttrWithException(value.toInt32(exec));
}

void setJSTestObjAttrWithSetterException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setAttrWithSetterException(value.toInt32(exec), ec);
    setDOMException(exec, ec);
}

void setJSTestObjAttrWithGetterException(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSTestObj* castedThis = static_cast<JSTestObj*>(thisObject);
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setAttrWithGetterException(value.toInt32(exec), ec);
    setDOMException(exec, ec);
}

void setJSTestObjCustomAttr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSTestObj*>(thisObject)->setCustomAttr(exec, value);
}

JSValue JSTestObj::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTestObjConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionVoidMethod(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());

    imp->voidMethod();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionVoidMethodWithArgs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    int intArg = exec->argument(0).toInt32(exec);
    const String& strArg = ustringToString(exec->argument(1).toString(exec));
    TestObj* objArg = toTestObj(exec->argument(2));

    imp->voidMethodWithArgs(intArg, strArg, objArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionIntMethod(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());


    JSC::JSValue result = jsNumber(exec, imp->intMethod());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionIntMethodWithArgs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    int intArg = exec->argument(0).toInt32(exec);
    const String& strArg = ustringToString(exec->argument(1).toString(exec));
    TestObj* objArg = toTestObj(exec->argument(2));


    JSC::JSValue result = jsNumber(exec, imp->intMethodWithArgs(intArg, strArg, objArg));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionObjMethod(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->objMethod()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionObjMethodWithArgs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    int intArg = exec->argument(0).toInt32(exec);
    const String& strArg = ustringToString(exec->argument(1).toString(exec));
    TestObj* objArg = toTestObj(exec->argument(2));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->objMethodWithArgs(intArg, strArg, objArg)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionMethodThatRequiresAllArgs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return JSValue::encode(jsUndefined());
    const String& strArg = ustringToString(exec->argument(0).toString(exec));
    TestObj* objArg = toTestObj(exec->argument(1));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->methodThatRequiresAllArgs(strArg, objArg)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionMethodThatRequiresAllArgsAndThrows(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createSyntaxError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& strArg = ustringToString(exec->argument(0).toString(exec));
    TestObj* objArg = toTestObj(exec->argument(1));


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->methodThatRequiresAllArgsAndThrows(strArg, objArg, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionSerializedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    RefPtr<SerializedScriptValue> serializedArg = SerializedScriptValue::create(exec, exec->argument(0));

    imp->serializedValue(serializedArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionMethodWithException(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->methodWithException(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionCustomMethod(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    return JSValue::encode(castedThis->customMethod(exec));
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionCustomMethodWithArgs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    return JSValue::encode(castedThis->customMethodWithArgs(exec));
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionCustomArgsAndException(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ExceptionCode ec = 0;
    ScriptCallStack callStack(exec, 1);
    log* intArg = tolog(exec->argument(0));

    imp->customArgsAndException(intArg, &callStack, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionAddEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->addEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionRemoveEventListener(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    JSValue listener = exec->argument(1);
    if (!listener.isObject())
        return JSValue::encode(jsUndefined());
    imp->removeEventListener(ustringToAtomicString(exec->argument(0).toString(exec)), JSEventListener::create(asObject(listener), castedThis, false, currentWorld(exec)).get(), exec->argument(2).toBoolean(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithDynamicFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    Frame* dynamicFrame = toDynamicFrame(exec);
    if (!dynamicFrame)
        return JSValue::encode(jsUndefined());

    imp->withDynamicFrame(dynamicFrame);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithDynamicFrameAndArg(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    Frame* dynamicFrame = toDynamicFrame(exec);
    if (!dynamicFrame)
        return JSValue::encode(jsUndefined());
    int intArg = exec->argument(0).toInt32(exec);

    imp->withDynamicFrameAndArg(dynamicFrame, intArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithDynamicFrameAndOptionalArg(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    Frame* dynamicFrame = toDynamicFrame(exec);
    if (!dynamicFrame)
        return JSValue::encode(jsUndefined());
    int intArg = exec->argument(0).toInt32(exec);

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->withDynamicFrameAndOptionalArg(dynamicFrame, intArg);
        return JSValue::encode(jsUndefined());
    }

    int optionalArg = exec->argument(1).toInt32(exec);

    imp->withDynamicFrameAndOptionalArg(dynamicFrame, intArg, optionalArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithDynamicFrameAndUserGesture(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    Frame* dynamicFrame = toDynamicFrame(exec);
    if (!dynamicFrame)
        return JSValue::encode(jsUndefined());
    int intArg = exec->argument(0).toInt32(exec);

    imp->withDynamicFrameAndUserGesture(dynamicFrame, intArg, processingUserGesture(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithDynamicFrameAndUserGestureASAD(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    Frame* dynamicFrame = toDynamicFrame(exec);
    if (!dynamicFrame)
        return JSValue::encode(jsUndefined());
    int intArg = exec->argument(0).toInt32(exec);

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->withDynamicFrameAndUserGestureASAD(dynamicFrame, intArg);
        return JSValue::encode(jsUndefined());
    }

    int optionalArg = exec->argument(1).toInt32(exec);

    imp->withDynamicFrameAndUserGestureASAD(dynamicFrame, intArg, optionalArg, processingUserGesture(exec));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithScriptStateVoid(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());

    imp->withScriptStateVoid(exec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithScriptStateObj(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->withScriptStateObj(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithScriptStateVoidException(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->withScriptStateVoidException(exec, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithScriptStateObjException(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ExceptionCode ec = 0;


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->withScriptStateObjException(exec, ec)));
    setDOMException(exec, ec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionWithScriptExecutionContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    ScriptExecutionContext* scriptContext = static_cast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());

    imp->withScriptExecutionContext(scriptContext);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionMethodWithOptionalArg(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());

    int argsCount = exec->argumentCount();
    if (argsCount < 1) {
        imp->methodWithOptionalArg();
        return JSValue::encode(jsUndefined());
    }

    int opt = exec->argument(0).toInt32(exec);

    imp->methodWithOptionalArg(opt);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionMethodWithNonOptionalArgAndOptionalArg(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    int nonOpt = exec->argument(0).toInt32(exec);

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->methodWithNonOptionalArgAndOptionalArg(nonOpt);
        return JSValue::encode(jsUndefined());
    }

    int opt = exec->argument(1).toInt32(exec);

    imp->methodWithNonOptionalArgAndOptionalArg(nonOpt, opt);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionMethodWithNonOptionalArgAndTwoOptionalArgs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    int nonOpt = exec->argument(0).toInt32(exec);

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt);
        return JSValue::encode(jsUndefined());
    }

    int opt1 = exec->argument(1).toInt32(exec);
    int opt2 = exec->argument(2).toInt32(exec);

    imp->methodWithNonOptionalArgAndTwoOptionalArgs(nonOpt, opt1, opt2);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionOverloadedMethod1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    TestObj* objArg = toTestObj(exec->argument(0));
    const String& strArg = ustringToString(exec->argument(1).toString(exec));

    imp->overloadedMethod(objArg, strArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionOverloadedMethod2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    TestObj* objArg = toTestObj(exec->argument(0));

    int argsCount = exec->argumentCount();
    if (argsCount < 2) {
        imp->overloadedMethod(objArg);
        return JSValue::encode(jsUndefined());
    }

    int intArg = exec->argument(1).toInt32(exec);

    imp->overloadedMethod(objArg, intArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionOverloadedMethod3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    const String& strArg = ustringToString(exec->argument(0).toString(exec));

    imp->overloadedMethod(strArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionOverloadedMethod4(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTestObj::s_info))
        return throwVMTypeError(exec);
    JSTestObj* castedThis = static_cast<JSTestObj*>(asObject(thisValue));
    TestObj* imp = static_cast<TestObj*>(castedThis->impl());
    int intArg = exec->argument(0).toInt32(exec);

    imp->overloadedMethod(intArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsTestObjPrototypeFunctionOverloadedMethod(ExecState* exec)
{
    if ((exec->argumentCount() == 2 && (exec->argument(0).isNull() || asObject(exec->argument(0))->inherits(&JSTestObj::s_info)) && (exec->argument(1).isNull() || exec->argument(1).isUndefined() || exec->argument(1).isString() || exec->argument(1).isObject())))
        return jsTestObjPrototypeFunctionOverloadedMethod1(exec);
    if ((exec->argumentCount() == 1 && (exec->argument(0).isNull() || asObject(exec->argument(0))->inherits(&JSTestObj::s_info))) || (exec->argumentCount() == 2 && (exec->argument(0).isNull() || asObject(exec->argument(0))->inherits(&JSTestObj::s_info))))
        return jsTestObjPrototypeFunctionOverloadedMethod2(exec);
    if ((exec->argumentCount() == 1 && (exec->argument(0).isNull() || exec->argument(0).isUndefined() || exec->argument(0).isString() || exec->argument(0).isObject())))
        return jsTestObjPrototypeFunctionOverloadedMethod3(exec);
    if (exec->argumentCount() == 1)
        return jsTestObjPrototypeFunctionOverloadedMethod4(exec);
    return throwTypeError(exec);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TestObj* object)
{
    return getDOMObjectWrapper<JSTestObj>(exec, globalObject, object);
}
TestObj* toTestObj(JSC::JSValue value)
{
    return value.inherits(&JSTestObj::s_info) ? static_cast<JSTestObj*>(asObject(value))->impl() : 0;
}

}
