package jp.co.spiritek.dev.mapapp;

import android.content.Context;
import android.location.Location;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;

public class TrackingMyLocationOverlay extends MyLocationOverlay {
	MapView mapView;
	public TrackingMyLocationOverlay(Context context, MapView mapView) {
		super(context, mapView);
        this.mapView = mapView;
	}

	public void onLocationChanged(Location location) {
        super.onLocationChanged(location);
        mapView.getController().animateTo(new GeoPoint(
                (int) (location.getLatitude() * 1E6), 
                (int) (location.getLongitude() * 1E6)));
        mapView.invalidate();
    }
}
