import java.net.URL;

import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceServiceLocator;
import com.sforce.soap.partner.SoapBindingStub;
import com.sforce.soap.schemas._class.ThermalMap.ThermalMapBindingStub;
import com.sforce.soap.schemas._class.ThermalMap.ThermalMapServiceLocator;
import com.sforce.soap.schemas._class.ThermalMap.Thermal__c;
/*
 * ݒ聨̌l񁨎̃ZLeBg[ÑZbg sꂽpX[hg
 * http://kptech.cocolog-nifty.com/blog/2011/05/apexsoap-25b6.html
 */
public class ApiTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			SoapBindingStub stub =(SoapBindingStub) new SforceServiceLocator().getSoap();
			LoginResult loginResult = stub.login("user@domain.com", "PasswordSequritytoken");
			stub._setProperty(SoapBindingStub.ENDPOINT_ADDRESS_PROPERTY, loginResult.getServerUrl());
			SessionHeader sh = new SessionHeader();
			sh.setSessionId(loginResult.getSessionId());
			
			ThermalMapBindingStub stub2 = new ThermalMapBindingStub( new URL("https://na12-api.salesforce.com/services/Soap/class/ThermalMap"), new ThermalMapServiceLocator());
			stub2.setHeader(new SforceServiceLocator().getServiceName().getNamespaceURI(), "SessionHeader", sh);
			Thermal__c[] thermals = null;
			long start = 0;
			for ( int i = 0; i < 10; i++ ){
				start = System.currentTimeMillis();
				thermals = stub2.add("aaa", "bbb", 90.0, 135.0, 800.0 + i, 5.0, 30L, 100.0, 4.0);
				System.out.println("time = " + (System.currentTimeMillis() - start));
			}
			for ( Thermal__c thermal : thermals){
				System.out.print(thermal.getArea__c() + " ");
				System.out.print(thermal.getDevid__c() + " ");
				System.out.print(thermal.getAlt__c() + " ");
				System.out.print(thermal.getInc__c() + " ");
				System.out.println();
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
