package com.csi.puchipuchi;


import java.util.Calendar;
import java.util.Locale;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.Preference.OnPreferenceChangeListener;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.preference.RingtonePreference;
import android.util.Log;
import android.widget.Toast;


public class PuchiSettingActivity extends PreferenceActivity
	implements OnPreferenceChangeListener, OnSharedPreferenceChangeListener{

	public void setClockTime(){
		CheckBoxPreference checkbox = (CheckBoxPreference)getPreferenceScreen().findPreference("checkbox1_key");

		AlarmManager am = (AlarmManager)getSystemService(ALARM_SERVICE); // AlramManager取得
		Intent i = new Intent(getApplicationContext(), PuchipuchiActivity.class); // インテントを作成
		PendingIntent sender = PendingIntent.getActivity(getApplicationContext(), 0, i, 0);

		if (checkbox.isChecked()) {
			Calendar calendar = Calendar.getInstance(); // Calendar取得
			calendar.setTimeInMillis(System.currentTimeMillis()); // 現在時刻を取得
			SharedPreferences sp = getSharedPreferences("com.csi.puchipuchi_preferences", MODE_PRIVATE);
			int set_hour = sp.getInt("TimePicker_Hour", 12);	//設定時間
			int set_minute = sp.getInt("TimePicker_Minute", 0);
			int set_second = 0;
			int now_hour = calendar.get(Calendar.HOUR_OF_DAY);	//現在時間
			int now_minute = calendar.get(Calendar.MINUTE);
			int now_second = calendar.get(Calendar.SECOND);
			int diff_total, set_total, now_total, diff_hour, diff_minute, diff_second;
			set_total = set_hour*3600 + set_minute*60 + set_second;
			now_total = now_hour*3600 + now_minute*60 + now_second;
			if(set_total > now_total){
				diff_total = set_total - now_total;
			} else {
				diff_total = set_total - now_total + (24*60*60);
			}
			diff_hour = diff_total / 3600;
			diff_minute = (diff_total-(diff_hour*3600)) / 60;
			diff_second = (diff_total-(diff_hour*3600)) % 60;

			Locale locale = Locale.getDefault();
			if (locale.equals(Locale.JAPAN)){
				Toast.makeText(this, "アラームが"+String.valueOf(diff_hour) +"時間"+String.valueOf(diff_minute)+"分後に設定されました", Toast.LENGTH_LONG).show();
			} else {
				Toast.makeText(this, "This alarm is set for "+String.valueOf(diff_hour) +" hours and "+String.valueOf(diff_minute)+" minutes from now", Toast.LENGTH_LONG).show();
			}
			calendar.add(Calendar.HOUR_OF_DAY, diff_hour);	// 時を設定
			calendar.add(Calendar.MINUTE, diff_minute);		// 分を設定
			calendar.add(Calendar.SECOND, diff_second);		// 秒を設定
			am.set(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(), sender); // AlramManagerにPendingIntentを登録
		} else {
			am.cancel(sender);
		}

	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		addPreferencesFromResource(R.layout.setting);

		ListPreference list_preference = (ListPreference)getPreferenceScreen().findPreference("list_key");
		String value = list_preference.getValue();
		if(value == "" || value == null){
			list_preference.setValue("3");
		}
		list_preference.setSummary(list_preference.getEntry());

	    RingtonePreference pref = (RingtonePreference) findPreference("ringtone_key");
	    pref.setOnPreferenceChangeListener(this);

	    SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this);
	    String url = sp.getString("ringtone_key", "");
	    if(url != ""){
	        Ringtone ringtone = RingtoneManager.getRingtone(this, Uri.parse(url));
	        pref.setSummary(ringtone.getTitle(this));
        }else{
			Locale locale = Locale.getDefault();
			if (locale.equals(Locale.JAPAN)){
				pref.setSummary("無音");
			}else{
				pref.setSummary("Silent");
			}
        }
	}

    @Override
	protected void onResume() {
		super.onResume();
		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
    }

	@Override
	protected void onPause() {
		super.onPause();
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
	}

	@Override
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
		if(key.equals("list_key")){
			ListPreference list_preference = (ListPreference)getPreferenceScreen().findPreference("list_key");
			list_preference.setSummary(list_preference.getEntry());
		}

		if(key.equals("checkbox1_key")){
			SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences(this);
			CheckBoxPreference checkbox_preference = (CheckBoxPreference)getPreferenceScreen().findPreference("checkbox1_key");
			if(pref.getBoolean("checkbox1_key", false) == true){
				checkbox_preference.setChecked(true);
				setClockTime();
			}else{
				checkbox_preference.setChecked(false);
			}
		}

//		Toast.makeText(this, key, Toast.LENGTH_LONG).show();
	}

	@Override
	public boolean onPreferenceChange(Preference preference, Object newValue) {
	    updateRingtoneSummary((RingtonePreference) preference, Uri.parse((String) newValue));
	    return true;
	}

	private void updateRingtoneSummary(RingtonePreference preference, Uri ringtoneUri) {
	    Ringtone ringtone = RingtoneManager.getRingtone(this, ringtoneUri);

	    if (ringtone != null)
	        preference.setSummary(ringtone.getTitle(this));
	    else
	        preference.setSummary("Silent");
	}

}