package jp.co.csoft.trump.game.view;

import jp.co.csoft.trump.R;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.TextView;

public class OrderActivity extends Activity implements OnClickListener {
	private static final String TAG = OrderActivity.class.getSimpleName();
    static String[] PREFS = { 
        "Sc@č؎q", "ʈ@D", "X؁@ʉ", "L@ǉ", "@", "" };

	int mDraggingPosition = -1;
	SampleAdapter mAdapter;
	SortableListView mListView;
	private String _name;
	private boolean _parent;

	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
//        requestWindowFeature(Window.FEATURE_NO_TITLE);
	    setContentView(R.layout.order);
	    mAdapter = new SampleAdapter();
	    mListView = (SortableListView) findViewById(R.id.list);
	    mListView.setDragListener(new DragListener());
	    mListView.setSortable(true);
	    mListView.setAdapter(mAdapter);

	    _name = getIntent().getExtras().getString("name");
	    PREFS[5] = _name;
	    _parent = getIntent().getExtras().getBoolean("parent");

	    Button btn = (Button)findViewById(R.id.buttonNext);  
        btn.setOnClickListener(this);  
	}

	public void onClick(View v) {
        Button b = (Button)v;  
        try {  
            if (b.getId() == R.id.buttonNext) {
                //Intent CX^X  
                Intent intent = new Intent(OrderActivity.this, DummyActivity.class);
//                for ( int i = 0; i < mAdapter.getCount(); i++ ){
//                	String aaa = mAdapter.getItem(i);
//                    Log.i(TAG, "aaa : " + aaa);
//                }
                intent.putExtra("names", PREFS);
                intent.putExtra("parent", _parent);
                //ʂN
                startActivity(intent);
            }  
        } catch (Exception e) {  
            Log.i(TAG, "aaa : " + e);
        }  
	}

	class SampleAdapter extends BaseAdapter {
//	    @Override
	    public int getCount() {
	        return PREFS.length;
	    }
	    
//	    @Override
	    public String getItem(int position) {
	        return PREFS[position];
	    }
	    
//	    @Override
	    public long getItemId(int position) {
	        return position;
	    }
	    
//	    @Override
	    public View getView(int position, View convertView, ViewGroup parent) {
	        if (convertView == null) {
	            convertView = getLayoutInflater().inflate(
	                    android.R.layout.simple_list_item_1, null);
	        }
	        final TextView view = (TextView) convertView;
	        view.setText(PREFS[position]);
	        view.setVisibility(position == mDraggingPosition ? View.INVISIBLE
	                : View.VISIBLE);
	        return convertView;
	    }
	}
	
	class DragListener extends SortableListView.SimpleDragListener {
	    @Override
	    public int onStartDrag(int position) {
	        mDraggingPosition = position;
	        mListView.invalidateViews();
	        return position;
	    }
	    
	    @Override
	    public int onDuringDrag(int positionFrom, int positionTo) {
	        if (positionFrom < 0 || positionTo < 0
	                || positionFrom == positionTo) {
	            return positionFrom;
	        }
	        int i;
	        if (positionFrom < positionTo) {
	            final int min = positionFrom;
	            final int max = positionTo;
	            final String data = PREFS[min];
	            i = min;
	            while (i < max) {
	                PREFS[i] = PREFS[++i];
	            }
	            PREFS[max] = data;
	        } else if (positionFrom > positionTo) {
	            final int min = positionTo;
	            final int max = positionFrom;
	            final String data = PREFS[max];
	            i = max;
	            while (i > min) {
	                PREFS[i] = PREFS[--i];
	            }
	            PREFS[min] = data;
	        }
	        mDraggingPosition = positionTo;
	        mListView.invalidateViews();
	        return positionTo;
	    }
	    
	    @Override
	    public boolean onStopDrag(int positionFrom, int positionTo) {
	        mDraggingPosition = -1;
	        mListView.invalidateViews();
	        return super.onStopDrag(positionFrom, positionTo);
	    }
	}
}